#include "kant.h" 


t_void
order_maximal_to_power WITH_4_ARGS(
	order,		ord,
	order *,	power_ord,
	matrix *,       trans,
	integer_big *,  den
)
/*******************************************************************************
 
Description:
 
       Computes the equation order given by an order and the transformation matrix
       with denominator.
 
 
Calling sequence:
 
	order_maximal_to_power(ord, &power_ord, &trans, &den);
 
      	order       ordold      = t_handle of an order 
      	order       power_old   = t_handle of an equation order 

      	matrix      trans       = transformation matrix
        integer_big den	        = denominator of trans
 
History:
 
	92-07-08 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

  	integer_small	n;
  	integer_big	h1;
	order		sub_ord;
	matrix		mat1;
	t_handle	        Z;
         


                         
	n= order_abs_degree(ord);
	Z= m_z_str_incref(structure_z);

	if ( order_basis_is_power(ord) || order_basis_is_pure(ord) )
	{   
         *power_ord= order_incref(ord);
	 *trans=  mat_ring_create_id(Z, n);
	 *den= 1;

	 ring_delete(&Z);
	 return;
	}
	else
	{
         /* ord is not equation order */

 	 if (!order_basis_is_rel(ord))
	 error_internal("order_maximal_to_power: Unknown situation.");

         /* lift trans from a suborder to the order */
 
	 sub_ord = order_suborder(ord);
	 order_maximal_to_power(sub_ord, power_ord, trans, den);

 	 h1= *den;
	 *den= integer_mult(h1, order_tran_den(ord));
	 integer_delete(&h1);

	 mat1= *trans;
	 *trans=  mat_ring_mult(Z, mat1, order_tran(ord));
	 mat_delref(Z, &mat1);

 	 ring_delete(&Z);
	 return;
	}
} 

