/******************************************************************************
  order_fac_basis_extend.c                                                           
******************************************************************************/
 

#include "kant.h"
 
t_void _update_rel_mat();


t_void
order_fac_basis_extend WITH_2_ARGS (order        ,   ord,
                                    integer_big  ,   prime)
/*******************************************************************************

Description: 
 

Calling sequence: 
	
 
History:

  
*******************************************************************************/
{
	block_declarations;
  
        t_handle           Z;        
        faclst             prime_fac;


        integer_small      pos_prime,fac_bas_len,len,i;

               
 
            
  if (!order_fac_basis(ord))
         order_fac_basis_create_one (ord, prime);
  else
    { 
      Z =  structure_z;




      order_fac_basis_len_get(ord,fac_bas_len);
      pos_prime = fac_bas_len+1;  

      while ((pos_prime >= 2 ) && 
             (integer_compare (order_fac_basis_prime (ord,pos_prime-1),prime) <=  0))
        pos_prime--;
                        
      if (integer_compare (order_fac_basis_prime (ord,pos_prime),prime) == 0) 
        return;


      prime_fac = order_prime_factorize (ord,prime);     
               
 
/*
     anf_ideal_faclst_write (ord,prime_fac);

     dyn_arr_assure_space(order_fac_basis(ord), (fac_bas_len)*2 + 1, 10); 
*/


      if (pos_prime <= fac_bas_len)
      {
        for (i=fac_bas_len;i>=pos_prime;i--)
        {
          order_fac_basis_prime (ord,i+1)  = order_fac_basis_prime (ord,i);
          order_fac_basis_ideals (ord,i+1) = order_fac_basis_ideals (ord,i);
        }
      }

                                                
      order_fac_basis_prime (ord,pos_prime)    = integer_incref (prime);
      order_fac_basis_ideals (ord,pos_prime)   = prime_fac;
      order_fac_basis_len_set (ord,fac_bas_len+1);
        
      len = m_poly_z_faclst_len (prime_fac)+ order_fac_basis_ideals_count (ord);
      order_fac_basis_ideals_count_set (ord,len);  



    }

    if (order_relation_mat (ord))
    {
      _update_rel_mat (ord,pos_prime,m_poly_z_faclst_len (prime_fac));
    }

    if (anf_print_level > 2)
    {
      len = order_fac_basis_len (ord);
      for (i=1;i<=len;i++)
        cay_print (",%d ",order_fac_basis_prime(ord,i));
      puts ("");
    }
}       
     


integer_small
get_no_of_ideals_above WITH_2_ARGS (order         , ord,
                                    integer_small , pos )
{                    
    block_declarations;

    integer_small         no,i;


 no = 0;

 for (i=1;i<pos;i++)
   no = no + m_poly_z_faclst_len (order_fac_basis_ideals (ord,i));

 
 return no;

}    

t_void 
_update_rel_mat WITH_3_ARGS  (order         , ord             ,
                              integer_small , pos_prime       ,
                              integer_small , no_of_new_ideals )
{                              
           block_declarations;

           t_handle       Z;                        
          
           matrix         rel_mat, mat1,mat2,mat3,mat4,mat5;



           integer_small  len,col_dim,i,j,above,below;



  Z           = structure_z;
  rel_mat     = order_relation_mat (ord);

  len         = order_fac_basis_ideals_count (ord);  
  above       = get_no_of_ideals_above (ord,pos_prime);
  below       = len - no_of_new_ideals - above;

  col_dim     = mat_col (rel_mat);
                 
                             

  if (anf_print_level > 4)
  {
    puts ("STAT:");
    printf ("below       : %d\n",below);
    printf ("above       : %d\n",above);
    printf ("new         : %d\n",no_of_new_ideals);
    printf ("len (ideals): %d\n",len);
    printf ("col_dim     : %d\n",col_dim);

    mat_anf_write (Z,order_relation_mat (ord));
  }


  mat1        = mat_new (len, col_dim);




  if ( below == 0)
  {
    mat2 = mat_ring_insert (Z,mat1,rel_mat,1,1);
 
    mat_delref (Z,&mat1); 
    mat_delref (Z,&rel_mat);
              
    order_relation_mat (ord) = mat2;
  }
  else
    if (above  == 0)
    {     
      mat2 = mat_ring_insert (Z,mat1,rel_mat,no_of_new_ideals+1,1);
 
      mat_delref (Z,&mat1); 
      mat_delref (Z,&rel_mat);
 
      order_relation_mat (ord) = mat2;
    }
    else
      {
        mat2 = mat_ring_submat (Z,rel_mat,1,1,above,col_dim);
        mat3 = mat_ring_submat (Z,rel_mat,
                                  above+1,1,below,col_dim);
        mat4 = mat_ring_insert (Z,mat1,mat2,1,1);
        mat5 = mat_ring_insert (Z,mat4,mat3,above+no_of_new_ideals+1,1);
 
        mat_delref (Z,&mat1); 
        mat_delref (Z,&mat2); 
        mat_delref (Z,&mat3); 
        mat_delref (Z,&mat4); 
        mat_delref (Z,&rel_mat);


        order_relation_mat (ord) = mat5;
                           
     }

    mat1 = order_relation_mat (ord);
                                    
    if (anf_print_level > 5)
    {
      for (j=1;j<=no_of_new_ideals;j++)
        for (i=1;i<=col_dim;i++)                        
          mat_elt (mat1,above+j,i) = 0;
      
      mat_anf_write (structure_z,order_relation_mat (ord));
    }
}


t_void 
update_rel_trans_mat WITH_1_ARG  (order , ord)
{
/* Not supported jet. I don`t know the way this matrix is defined.          */
}
