#include "kant.h"

/* Comp. of the rel. field - disc. for extensions of degree 2 */



anf_ideal
anf_rel_field_disc WITH_5_ARGS (order           , ord              ,
                                anf_elt         , my               ,
                                t_handle        * , faclst_disc      ,
				t_handle        * , faclst_sqr_index ,
                                integer_small * , pos_index_my       ) 

/* 
   We set F := Quot (ord) and assume ord to be the max. order of F.
   Moreover we define 
                     E := F(sqrt (my))
   Our aime is it to compute the relative field disc. of E/F        
*/
{
            block_declarations;

            t_handle          faclst_2,faclst_my;
            dyn_arr_handle  list;          

            anf_ideal       ideal,field_disc;
            anf_ideal       disc_2,disc_my;

            anf_elt         two,gamma,ny;          

	    integer_small   j,i,bound,pos,power,len;
	    t_logical         ok,find_all;





             
  two = 2;   
  faclst_my  = anf_elt_factorization_md (ord,my);
  faclst_2   = anf_elt_factorization_md (ord,two);   

  if (faclst_my == MEM_NH) 
    error_internal ("ANF_REL_FIELD_DISC : Can't factorize my");

  if (faclst_2 == MEM_NH) 
    error_internal ("ANF_REL_FIELD_DISC : Can't factorize 2");
  



  if (anf_print_level > 2)
  {
    printf ("Factorisation of my = ");anf_elt_write (ord,my);
    printf (" --> ");
    anf_ideal_faclst_write (ord,faclst_my);puts ("");

                             
    printf ("\n\nFactorisation of 2  = ");anf_elt_write (ord,two);
    printf (" --> ");
    anf_ideal_faclst_write (ord,faclst_2);puts ("");
  }

/* Now compute the factorization of the relative disc.          */
/* into prime - ideals.                                         */
                 
/* First init some variables                                    */

   *pos_index_my = 0; 

   *faclst_disc      = MEM_NH;
   *faclst_sqr_index = MEM_NH;
   disc_2            = MEM_NH;
   disc_my           = MEM_NH;


/* First check the prime - ideals lying above 2               */
  
   anf_rel_field_disc_2_fac (ord,my,faclst_2,&faclst_my,
                                    faclst_disc,faclst_sqr_index,&disc_2);
 
   if (*faclst_sqr_index != MEM_NH)
     *pos_index_my = m_poly_z_faclst_len (*faclst_sqr_index);

/* Now check the prime - ideals lying above  my and not above */
/* 2 ( simply the rest )                                      */ 
      
   anf_rel_field_disc_my_fac (ord,my,faclst_my,faclst_disc,
					       faclst_sqr_index,&disc_my);                    


  if (anf_print_level > 2)
  {
    printf ("\n\nFactorisation of rel. disc : ");
    printf (" --> ");
    if (*faclst_disc != MEM_NH)
      anf_ideal_faclst_write (ord,*faclst_disc);
    puts ("");
  }

  
  anf_ideal_faclst_delete (ord,&faclst_2);
  anf_ideal_faclst_delete (ord,&faclst_my);
  anf_elt_delete (ord,&two);                              
           
  if ( (disc_2 == MEM_NH) && (disc_my == MEM_NH) )
    ideal = anf_ideal_2_create (ord,1,1);
  else
    if (disc_2 == MEM_NH)
      ideal = anf_ideal_incref (disc_my);
    else
      if (disc_my == MEM_NH)
        ideal = anf_ideal_incref (disc_2);
      else
        ideal = anf_ideal_mult (ord,disc_2,disc_my);         
                                     
         
  if (disc_2 != MEM_NH)
    anf_ideal_delete (ord,&disc_2);
  if (disc_my != MEM_NH)
    anf_ideal_delete (ord,&disc_my);

  return ideal;

}                           


