#include "kant.h"

anf_ideal
anf_ideal_mult_faclst_range WITH_4_ARGS (order         , ord   ,
                                         faclst        , fac   ,
					 integer_small , lower ,
					 integer_small , upper  )
/*******************************************************************************
 
Description:
 
      The function assumes, that the faclst is not empty and will return the
      following ideal:
                      upper
                      ---                     faclst_power (i)
              ideal = | |     faclst_ideal (i)
                      i=lower
 
Calling sequence:
 
 
      	order  	      ord         : order of a field
        faclst        fac         : a non-empty faclst

        integer_small lower,upper : the range of the multiplication.
  
        anf_ideal     ideal       : product as desc. above.                                            

              ideal = anf_ideal_mult_faclst_range (ord,fac,lower,upper);

History:                                          
 
	92-09-07 MD     written
 
*******************************************************************************/
{

          block_declarations;

          anf_ideal        ideal,temp1,temp2;

          integer_small    i;



 

  ideal = anf_ideal_2_create (ord,1,1);  /* The "one" within the ideals */

  for (i=lower;i<upper;i++)
  {
    if (m_poly_z_faclst_power  (fac,i) != 0)
    {
      temp1 = anf_ideal_power (ord,m_poly_z_faclst_factor (fac,i),
                                   m_poly_z_faclst_power  (fac,i) );
      temp2 = anf_ideal_mult (ord,ideal,temp1);

      anf_ideal_delete (ord,&ideal);
      anf_ideal_delete (ord,&temp1);
 
      ideal = temp2;
    }
  }
 
  return ideal;


}






