#include "defs.h"
#include "integer.e"
#include "q.e"
#include "q.h"

integer_big
q_round WITH_2_ARGS(
	t_handle,		field,
	rational,	r
)
/*
Returns the rounded integer value of r.
*/
{
    block_declarations;
    integer_big		temp, q, d, temp2;

    if (r == 0)
    {
	return 0;
    }

    q_fix_sign(r);

    d = q_denom(r);

    temp = integer_mult(2, q_numer(r));
    temp2 = integer_add(temp, d);
    integer_delref(temp);

    temp = integer_mult(2, d);
    integer_quot_rem(temp2, temp, &q, &r);

    integer_delref(r);

    return q;
}
