#include "defs.h"
#include "integer.e"
#include "q.h"

void
q_fix_sign WITH_1_ARG(
	rational,	r
)
/*
Make r have positive denominator.
*/
{
    block_declarations;
    integer_big	denom;

    if (r == 0)
    {
	return;
    }

    denom = q_denom(r);
    if (integer_compare(denom, 0) < 0)
    {
	integer_big	temp;

	temp = q_numer(r);
	q_numer(r) = integer_negate(temp);
	integer_delref(temp);

	q_denom(r) = integer_negate(denom);
	integer_delref(denom);
    }
}

