#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"
#include "poly_mat.h"

dyn_arr_handle
poly_u_zm_fact_b4 WITH_4_ARGS(
    t_handle,      pring,
    integer_big,   pdig,
    t_poly,     apoly,
    t_handle,        vectorsh
)
/*
** MODUPOLY_FACT_B4: Modular univariate polynomial factorisation using
** the Berlekamp algorithm - Step 4. ( MUPFBL ).
**
** pdig: prime beta-integer
** vectorsh: matrix of vector entries of nullspace of Qmatrix.
** apoly: univariate polynomial over Zpdig.
** Returns: a list of the factors of apoly in polynomial form.
*/
{
	if ( pdig >= 25 )
	{
		return poly_u_zm_fact_b4_large( pring, pdig, apoly, vectorsh );
	}
	else
	{
		return poly_u_zm_fact_b4_small( pring, pdig, apoly, vectorsh );
	}
}

