#include "defs.h"
#include "mp.e"
#include "mp.h"


mp_int
mp_to_int	WITH_1_ARG(
	mp_float,	x
)
/*
Returns the integer part of multi-precision x, assuming that x is not too
large (else use mp_to_int_mp()).  The result is truncated towards zero,
regardless of the current rounding type.
*/
{
    mp_ptr_type		xp = mp_ptr(x);
    mp_int		iz = 0, limit;
    mp_expt_type	expt;
    mp_base_type	b;
    mp_length		t, i;
    mp_bool		error = FALSE;


    DEBUG_BEGIN(DEBUG_OTHER);
    DEBUG_PRINTF_1("+mp_to_int {\n");
    DEBUG_1("x = ", xp);

    if (mp_is_zero(xp) || (expt = mp_expt(xp)) <= 0)
    {
	DEBUG_PRINTF_1("-} i = 0\n");
	DEBUG_END();

	return 0;
    }

    b = mp_b(xp);
    t = mp_t(xp);

    limit = MAX_INT / b;

    for (i = 0; i < expt; i++)
    {
	/*
	Check whether b * iz would exceed MAX_INT.
	*/

	if (iz > limit)
	{
	    error = TRUE;
	    break;
	}

	iz *= b;

	if (i < t)
	{
	    register mp_int	dig = mp_digit(xp, i);

	    if (dig > MAX_INT - iz)
	    {
		error = TRUE;
		break;
	    }

	    else
		iz += dig;
	}
    }

    if (error)
	mp_error("mp_to_int: x too large to fit in an integer");

    DEBUG_PRINTF_2("-} i = %d\n", mp_sign(xp) * iz);
    DEBUG_END();

    return mp_sign(xp) * iz;
}


mp_float
mp_to_int_mp	WITH_2_ARGS(
	mp_float,	x,
	mp_float,	y
)
/*
Returns y = integer part of x (truncated towards 0).  This
function should be used if x is too large to be represented as a
single-precision integer.  The current rounding type is irrelevant.
*/
{
    mp_ptr_type		xp = mp_ptr(x), yp = mp_ptr(y);


    DEBUG_BEGIN(DEBUG_OTHER);
    DEBUG_PRINTF_1("+mp_to_int_mp {\n");
    DEBUG_1("x = ", xp);

    /*
    Check for compatible parameters.
    */

    mp_check_2("mp_to_int_mp", xp, yp);


    mp_copy_ptr(xp, yp);

    if (!mp_is_zero(xp))
    {
	mp_expt_type	expt = mp_expt(xp);
	mp_length	t = mp_t(xp);

	if (expt < 1)
	    mp_set_sign(yp, 0);

	else if (expt < t)
	    mp_set_digits_zero(mp_digit_ptr(yp, expt), t - expt);
    }

    DEBUG_1("-} y = ", yp);
    DEBUG_END();

    return y;
}
