#include <stdio.h>
#include <varargs.h>

#include "defs.h"
#include "mp.e"
#include "mp.h"

#ifndef NO_DEBUG



#define TAB		4
#define level		mp_priv_debug_level
#define indent		mp_priv_indent


static void dump(p, n)
mp_digit_ptr_type	p;
mp_length		n;
{
    while (n-- > 0)
	printf("%d ", *p++);
}



mp_debug_mask
mp_debug_on WITH_1_ARG(
	mp_debug_mask, mask
)
/*
Turns the debug type on.
*/
{
    mp_debug_mask	old = mp_debug_flags;

    mp_debug_flags |= mask;
    return old;
}



mp_debug_mask
mp_debug_off WITH_1_ARG(
	mp_debug_mask, mask
)
/*
Turns the debug type off.
*/
{
    mp_debug_mask	old = mp_debug_flags;

    mp_debug_flags &= ~mask;
    return old;
}




void mp_priv_debug_printf(va_alist)
/*
Set indentation level according to first character of the printf argument
(+ = post-increment, - = pre-decrement; anything else = no change), and
indented suitably.  The format string is then passed to printf with any
optional arguments.
*/
va_dcl
{
    va_list	args;
    char	*msg;
    int		old_indent;


    if (level < 1)
	return;

    va_start(args);

    msg = va_arg(args, char *);

    if (*msg == '-' && indent > 0)
    {
	indent--;
	msg++;
    }

    old_indent = indent;

    if (*msg == '+')
    {
	putchar('\n');
	indent++;
	msg++;
    }

    printf("%*s", old_indent * TAB, NULL);

    vprintf(msg, args);


    va_end(args);
}


static void print_mp(z)
mp_ptr_type z;
{
    int i;

    if (mp_is_zero(z))
    {
	putchar('0');
	return;
    }

    putchar(mp_is_pos(z)? '+': '-');
    putchar('.');

    dump(mp_digit_ptr(z, 0), mp_t(z));

    printf("E%d (b = %d, t = %d, r = %d)", mp_expt(z), mp_b(z), mp_t(z), round);
}


void mp_priv_debug_1 	WITH_2_ARGS(
	char *,		msg,
	mp_ptr_type,	z
)
/*
Display message, followed by the mp float z
*/
{
    if (level < 1)
	return;

    mp_priv_debug_printf(msg);

    print_mp(z);
    putchar('\n');
}


void mp_priv_debug_dump WITH_3_ARGS(
	char *,			msg,
	mp_digit_ptr_type,	p,
	mp_int,			n
)
{
    if (level < 1)
	return;

    mp_priv_debug_printf(msg);

    dump(p, n);

    putchar('\n');
}

#endif
