#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "modint.e"

t_poly
modpoly_exp WITH_4_ARGS(
        t_handle,       pring,
	integer_big,	mdig,
	t_poly,	apoly,
	t_int,	power
)
/*
** modpoly_exp : integral polynomial exponentation.
** apoly is a polynomial , power is a non-negative beta-integer
** mdig is the modulus,
** returns apoly^power mod mdig
*/
{
	block_declarations;
	t_poly	bpoly;
	t_poly	cpoly;
	t_int	ndash;
	t_poly	temp;

	if ( m_poly_const( apoly ) )
	{
		/* apoly constant and non-zero, power > 0 */

		return modint_exp( mdig, apoly, power );
	}

	if ( power == 0 )
	{
		/* mdig != apoly as one constant, one not */

		return poly_z_constant_poly (pring, apoly, 1);
	}

	/* apoly not constant, power non-zero, general case */

	bpoly = poly_z_constant_poly (pring, apoly, 1);
	cpoly = m_modpoly_incref( pring, apoly );
	ndash = power;

	for ( ;; )
	{
		if ( ndash & 1 )
		{
			temp = bpoly;
			bpoly = modpoly_mult( pring, mdig, temp, cpoly );
			m_modpoly_delref( pring, temp );
		}

		if ( ! ( ndash >>= 1 ) )
		{
			break;
		}

		temp = cpoly;
		cpoly = modpoly_mult( pring, mdig, temp, temp );
		m_modpoly_delref( pring, temp );
	}

	m_modpoly_delref( pring, cpoly );

	return bpoly;
}
