#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "integer.e"
#include "zm.e"

void
mat_zm_scalar_mult_sub WITH_4_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	b,
	matrix *, 	pc
)
/*
** *pc := a * b, b an element of cring, a is a matrix over cring.
*/
{
	register t_int		dsq;
	register t_int		i;
	t_int		m;
	t_int		n;
	integer_big		modulus;
	Logical	respack;
	matrix	mata;
	matrix	matc;

	mata = matc = 0;

	m = mat_row(a);
	n = mat_col(a);

	modulus = zm_modulus(cring);

	respack = mat_result_pkd(cring, *pc);
	mat_alloc_result_unpkd(respack, *pc, matc, m, n);
	mat_create_unpkd(cring, a, mata, m, n);

	dsq = m * n;
	for (i = 1; i <= dsq; i++)
	{
		mat_entry(matc, i) = modint_mult(modulus, mat_entry(mata, i), b);
	}

	mat_create_result(cring, respack, *pc, matc);
	mat_free_unpkd(a, mata);
}


matrix
mat_zm_scalar_mult WITH_3_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big,	b
)
/*
** *pc := a * b, b an element of cring, a is a matrix over cring.
*/
{
	matrix c = 0;
	mat_zm_scalar_mult_sub(cring, a, b, &c);
	return c;
}

