#include "defs.h"
#include "ring.h"
#include "error.e"
#include "integer.e"
#include "mat.h"

void
mat_z_echelon WITH_10_ARGS(
	t_handle,		cring,
	matrix,		a,
	integer_big *,	det1,
	integer_small *,rank,
	matrix *,	echelon,
	Logical *,	unit,
	Logical, 	istoreduce,
	matrix *,	transform,
	Logical,	istoinverse,
	t_int,		start_row
)
/*
 * This procedure will find out determinant, rank, standard echelon form of a,
 * reduced echelon form, standard echelon transform, reduced echelon transform,
 * inverse and test whether a is unit.
 */
{
	block_declarations;
	integer_small	i;
	integer_small	j;
	integer_small	m;
	integer_small	p;
	integer_small	col;
	t_int		tem;
	t_int		mul;
	integer_small	pivrow;
	t_int		value;
	integer_small	start;
	t_int 		temp1;
	t_int		temp2;
	t_int		temp3;
	t_int		currow;
	Logical 	respack;
	Logical 	respack1;
	Logical 	isdiag;
	t_int		det;
	t_int		nrow;
	t_int		ncol;
	matrix		adash;
	matrix		edash;
	matrix		tdash;
	Logical 	stop;
	t_int		*aptr;
	t_int		*eptr;
	integer_big	absval;

	adash = edash = tdash = 0;
	nrow = mat_row(a);
	ncol = mat_col(a);
	isdiag = TRUE;

	/*
	 * if looking for determinant or unit or inverse
	 * and a is not a square matrix
	 */
	if (
		((det1 != 0) || (unit != 0) || istoinverse)
				&&
		(nrow != ncol)
	)
	{
		error_internal("Non-square matrix is found in mat_z_echelon");
	}
		
	if (echelon != 0)
	{
		respack = mat_result_pkd(cring, *echelon);
		edash = 0;
		mat_alloc_result_unpkd(respack, *echelon, edash, nrow, ncol);
	}
	else 
	{
		edash = mat_buff_alloc(nrow, ncol);
	}

	if (transform != 0)
	{
		respack1 = mat_result_pkd(cring, *transform);
		tdash = 0;
		mat_alloc_result_unpkd(respack1, *transform, tdash, nrow, nrow);
		mat_ring_create_id_sub(cring, tdash);
	}

	adash = 0;
	mat_create_unpkd(cring, a, adash, nrow, ncol);

	/*
	 * copy all elements in adash to edash
	 */
	
	aptr = mat_elt0_ptr(adash);
	eptr = mat_elt0_ptr(edash);
	
	for (i = 1; i <= (nrow * ncol); i++)
		eptr[i] = aptr[i];

	mat_incref_entries(cring, adash);

	det = 1;
	currow = 0;

	for (col = 1; col <= ncol && currow < nrow; col++)
	{
		++currow;
		pivrow = 0;
		/*
		 * find the a non-zero element in current colume
		 */
		for (j = currow; j <= nrow; j++)
		{
			value = mat_elt(edash, j, col);
			if (integer_sign(value))
			{
				pivrow = j;
				integer_incref(value);
				absval = integer_abs( value );
				break;
			}
		}
		/*
		 * ...find element of smallest non-zero absolute value
		 * in lower part of current column
		 */
		for (i = j; i <= nrow; i++)
		{
			tem = integer_abs(mat_elt(edash,i, col));
			if ((!integer_sign(tem)) || (integer_compare(tem, absval)>=0))
			{
				integer_delete(&tem);
				continue;
			}
			integer_delete( &value );
			integer_delete( &absval );
			value = integer_incref(mat_elt(edash, i, col));
			absval = tem;
			pivrow = i;
		}


		/*
		 * ...stop if column was all zero
		 */
		if (pivrow == 0)
		{
			--currow;
			continue;
		}

/* AKS: change from MJ via JS: */
		integer_delref(absval);

		/*
		 * ...start to perform integral pivot on the (pivrow,col) entry
		 * we do not bother to alter the above-diagonal part until
		 * the last time, when the pivot is + or - one.
		 */
		if (pivrow >= start_row)
			start = currow;
		else
			start = start_row;
		stop = FALSE;
		while (!stop)
		{
			stop = TRUE;
			for (i = start; i <= nrow; i++)
			{
				if (i == pivrow || (!integer_sign(mat_elt(edash, i, col))))
					continue;
				tem = mat_elt(edash, i, col);
				/*
				 * if tem and value are in different sign
				 */
				if ((integer_sign(tem) < 0 && integer_sign(value) > 0) 
				|| 
				(integer_sign(tem) > 0 && integer_sign(value) < 0))
				{
					temp1 = integer_abs(tem);
					temp2 = integer_abs(value);
					temp3 = integer_div(temp1, temp2);
					tem = integer_negate(temp3);
					integer_delete(&temp1);
					integer_delete(&temp2);
					integer_delete(&temp3);
				}
				else
					tem = integer_div(tem, value);
	
				/*
				 * row reduce of rows below currow
				 */
				temp1 = integer_negate( tem );
				integer_delete( &tem );
				mat_z_row_add( cring, edash, pivrow, i, temp1, col, ncol );

				if (transform != 0)
				{
					mat_z_row_add( cring, tdash, pivrow, i, temp1, 1, nrow );
				}
				integer_delete( &temp1 );

				/*
				 * ...have we found a smaller entry to pivot on
				 */
				if (!integer_sign(mat_elt(edash, i, col)))
					continue;
				integer_delete(&value);
				value = integer_incref(mat_elt(edash, i, col));
				pivrow = i;
				stop = FALSE;
				break;

			}
		}

		/*
		 * ...no smaller pivot was available
		 */
		
		/*
		 * if looking for inverse but the determinant found is not 1 or -1 which
		 * means that determinant is not unit in Z, so no inverse can be found
		 */
		DENY (istoinverse && integer_compare(value, 1) && integer_compare(value, -1));

		temp1 = integer_mult(det, value);
		integer_delete(&det);
		det = temp1;
		/*
		 * ...the column must now be all zero, except for the pivotal
		 * entry, which is plus or minus one.
		 */
		if (pivrow != currow)
		{
			/*
			 * ...swap rows pivrow and col to bring the pivotal entry to
			 * the main diagonal.
			 */
			temp1 = integer_negate(det);
			integer_delete(&det);
			det = temp1;
			mat_ring_row_swap( cring, edash, pivrow, currow, col, ncol );
			if (transform != 0)
			{
				mat_ring_row_swap( cring, tdash, pivrow, currow, 1, nrow );
			}
		}

		if (integer_sign(value) < 0)
		{
			/*
			 * negate all elements in currow
			 */
/* Deleted by MJ due to mail from Allan
 			temp1 = integer_negate(det);
			integer_delete(&det);
			det = temp1;  
*/
			mat_z_row_mult( cring, edash, currow, -1, col, ncol );
			if (transform != 0)
			{
				mat_z_row_mult( cring, tdash, currow, -1, 1, nrow );
			}
		}
		integer_delete(&value);
	}

	if (istoreduce)
	{
		/*
		 * to reduce the matrix edash to be reduced echelon form
		 */
		if (!istoinverse)
		{
			col = 1;
			for (i = 2; i <= currow; i++)
			{
				for (j = col + 1; j <= ncol; j++)
					if (integer_sign(mat_elt(edash, i, j)))
						break;
				if ( j > ncol )
					break;
				col = j;
				for (m = 1; m < i; m++)
				{
					if (!integer_sign(mat_elt(edash, m, j)))
						continue;
					if( integer_sign(mat_elt(edash, m, j)) < 0)
						mul = integer_div(mat_elt(edash, m, j), mat_elt(edash, i, j));
					else if (
						integer_compare(mat_elt(edash, m, j), mat_elt(edash, i, j)) < 0)
						continue;
					else mul = integer_div(mat_elt(edash, m, j), mat_elt(edash, i, j));

					temp1 = mul;
					mul = integer_negate( temp1 );
					integer_delete( &temp1 );
					mat_z_row_add( cring, edash, i, m, mul, j, ncol );

					if (transform != 0)
					{
						mat_z_row_add( cring, tdash, i, m, mul, 1, nrow );
					}
					integer_delete(&mul);
				}
			}
		}
		else
		{
			col = currow;
			for (i = currow; i >= 2; i--)
			{
				for (m = 1; m < i; m++)
				{
					if (!integer_sign(mat_elt(edash, m, col)))
						continue;
					mul = integer_negate(mat_elt(edash, m, col));
					if (echelon)
					{
						tem = mat_elt(edash, m, col);
						mat_elt(edash, m, col) = 0;
						integer_delete(&tem);
					}
					mat_z_row_add( cring, tdash, i, m, mul, 1, nrow );
					integer_delete(&mul);
				}
				col--;
			}
		}
	}


	if (isdiag)
	{
		if (unit != 0)
		{
			temp1 = integer_abs(det);
			if (integer_compare(temp1, 1))
			*unit = FALSE;
			else *unit = TRUE;
			integer_delete(&temp1);
		}
		if (det1 != 0)
			*det1 = det;
		else 
		{
			integer_delete(&det);
		}
	}
	else 
	{
		integer_delete(&det);
	}
	if (rank != 0)
		*rank = currow;
	if (transform != 0)
	{
		mat_create_result(cring, respack1, *transform, edash);
	}
	if (echelon != 0)
	{
		mat_create_result(cring, respack, *echelon, edash);
	}
	else 
	{
		mat_delete_entries(cring, edash);
		mat_buff_free(&edash);
	}
	mat_free_unpkd(a, adash);
}
