/*  integer_lcm.c
*/

#include "defs.h"
#include "integer.e"


integer_big
integer_lcm	WITH_2_ARGS(
    integer_big,    a,
    integer_big,    b
)
/*
Returns the least common multiple of the two arguments. Note that lcm(a,0) = 0.
*/
{
    block_declarations;
    integer_big	lcm;

    DEBUG_INTEGER_2("+integer_lcm", a, b);

    if (integer_sign(a) == 0 || integer_sign(b) == 0)
	lcm = 0;
    else
    {
	/*
	lcm(a, b) = b * (a / gcd(a, b))
	*/

	integer_big	pa, pb, gcd, a_on_gcd;

	pa = integer_abs(a);
	pb = integer_abs(b);
	gcd = integer_gcd(pa, pb);

	a_on_gcd = integer_div(pa, gcd);
	integer_delref(pa);
	integer_delref(gcd);

	lcm = integer_mult(pb, a_on_gcd);
	integer_delref(pb);
	integer_delref(a_on_gcd);
    }

    DEBUG_INTEGER_1("-integer_lcm", lcm);

    return lcm;
}
