#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"
#include "dyn_arr.e"
#include "dyn_arr.h"
#include "faclst.e"
#include "faclst.h"
#include "error.e"

integer_big
integer_carmichael_lambda   WITH_1_ARG(
    integer_big,    n
)
/*
** Return the value of the Carmichael lambda function of the general
** integer n.
**
** Algorithm taken from H. Riesel, Prime Numbers and Computer Methods
** for Factorization (Birkhauser, 1985)
*/
{
    block_declarations;

    register t_int  i;
    register t_int  k;
    register integer_big    p;
    register t_int  a;
    register integer_big    lambda;
    register integer_big    new_lambda;
    register integer_big    temp;
    register integer_big    p1;
    register integer_big    val;
    faclst                  factors;
    dyn_arr_handle          remainders;
    Logical                 proof;

    proof = 1;      /* require probable prime factors to be proven prime */
    integer_lst_factorise(  n, &factors, &remainders,
			    10, 1000, 1023, 10, 500, 3, 100, n, proof);

    if (remainders != 0)
    {
	faclst_delete( &factors );
	dyn_int_arr_delete( &remainders );
	error_runtime(ERR_COULD_NOT_FACTOR_ARG, 1);
    }

    k = faclst_num_prime( factors );
    lambda = 1;
    for (i = 0; i < k; i++)
    {
	p = faclst_prime( factors, i );		/* alias */
	a = faclst_expon( factors, i );		/* alias */
	if (( integer_compare( p, 2 ) == 0 && a <= 2) || integer_compare( p, 2 ) != 0 )
	{
	    temp = integer_power( p, a-1 );
	    p1 = integer_subtract( p, 1 );
	    val = integer_mult( temp, p1 );
	    integer_delref( temp );
	    integer_delref( p1 );
	}
	else
	{
	    val = integer_power(2, a - 2);
	}

	new_lambda = integer_lcm( lambda, val );
	integer_delref( val );
	integer_delref( lambda );
	lambda = new_lambda;		/* transfer */
    }

    faclst_delete( &factors );
    return lambda;
}
