#include "defs.h"
#include "mp.e"
#include "mp.h"
#include "integer.e"
#include "q.h"
#include "conv.e"

mp_float
conv_q_to_mp WITH_2_ARGS(
	rational,	q,
	mp_float,	x
)
/*
Converts the rational number q=i/j to multi-precision x and returns x
where i & j are big integers.
*/
{
    integer_big	i;
    integer_big	j;

    if ( q == 0 )
    {
	mp_int_to_mp(0, x);

	return x;
    }

    i = q_numer( q );
    j = q_denom( q );

    conv_int_to_mp(i, x);

    if (integer_is_single(j))
	mp_div_int_eq(x, j);
    else
    {
	mp_acc_float	temp;
	mp_ptr_type	x_ptr = mp_ptr(x);

	mp_acc_float_alloc(mp_b(x_ptr), mp_t(x_ptr), temp);

	conv_int_to_mp(j, temp);
	mp_div_eq(x, temp);

	mp_acc_float_delete(temp);
    }

    return x;
}

