/*******************************************************************************
  order_fincke_lambda_calc.c
 
    no_sig_less_n
    order_fincke_lambda_calc

********************************************************************************/


#include "kant.h"


extern t_real fincke_func ();
integer_small no_sig_less_n ();
    

void 
order_fincke_lambda_calc WITH_1_ARG (order , ord) 
/*******************************************************************************
 
Description:
 
    For a detailed description refer to FINCKE, PH.D.Thesis.
                   
    Findes and sets the optimal lambda as described in the thesis.
    Lambda is definded as the unique zero of a function (for more information
    read the thesis. 

 
Calling sequence:
 
 
      	order  	        ord      = t_handle of an order 

                 order_fincke_lambda_calc (ord);


History:
 
	92-06-12 MD     written
 
*******************************************************************************/
{
#define no_of_signatures 254

static double gamma_opt [no_of_signatures] = {
/* 2  2 */         0.69715891,   
/* 2  0 */         0.10000000,
      
/* 3  3 */         1.93928413,
/* 3  1 */         0.68043406,
      
/* 4  4 */         4.11750124,
/* 4  2 */         1.88034833,
/* 4  0 */         0.67228595,
      
/* 5  5 */         7.92904489,
/* 5  3 */         3.97796214,
/* 5  1 */         1.84615857,
      
/* 6  6 */        14.59624477,
/* 6  4 */         7.63939127,
/* 6  2 */         3.88840877,
/* 6  0 */         1.82385863,
      
/* 7  7 */        26.25859140,
/* 7  5 */        14.03031928,
/* 7  3 */         7.44082532,
/* 7  1 */         3.82614121,
                             
/* 8  8 */        46.66007661,
/* 8  6 */        25.18881895,
/* 8  4 */        13.62391381,
/* 8  2 */         7.29640642,
/* 8  0 */         3.78036586,
      
/* 9  9 */        82.35243353,
/* 9  7 */        44.67801460,
/* 9  5 */        24.39362544,
/* 9  3 */        13.31830888,
/* 9  1 */         7.18672089,
      
/*10 10 */       144.80096510,
/*10  8 */        78.72784036,
/*10  6 */        43.16492503,
/*10  4 */        23.78010580,
/*10  2 */        13.08032007,
/*10  0 */         7.10061840,
      
/*11 11 */       254.07019270,
/*11  9 */       138.23223055,
/*11  7 */        75.90163896,
/*11  5 */        41.97349269,
/*11  3 */        23.29277662,
/*11  1 */        12.88983284,
      
/*12 12 */       445.27433918,
/*12 10 */       242.24285081,
/*12  8 */       133.02131347,
/*12  6 */        73.63908152,
/*12  4 */        41.01180593,
/*12  2 */        22.89654050,
/*12  0 */        12.73396287,
      
/*13 13 */       779.86731118,
/*13 11 */       424.08107382,
/*13  9 */       232.72507321,
/*13  7 */       128.79200123,
/*13  5 */        71.78842905,
/*13  3 */        40.21970175,
/*13  1 */        22.56815769,
      
/*14 14 */      1365.40185016,
/*14 12 */       742.03082003,
/*14 10 */       406.81916850,
/*14  8 */       224.91049344,
/*14  6 */       125.29392820,
/*14  4 */        70.24752828,
/*14  2 */        39.55622586,
/*14  0 */        22.29164006,
      
/*15 15 */      2390.11475619,
/*15 13 */      1298.04597120,
/*15 11 */       710.89348697,
/*15  9 */       392.50590456,
/*15  7 */       218.38546415,
/*15  5 */       122.35443453,
/*15  3 */        68.94519090,
/*15  1 */        38.99256137,
      
/*16 16 */      4183.45838400,
/*16 14 */      2270.48290249,
/*16 12 */      1242.11926211,
/*16 10 */       684.85423800,
/*16  8 */       380.45651605,
/*16  6 */       212.85885502,
/*16  4 */       119.85080540,
/*16  2 */        67.83036191,
/*16  0 */        38.50786294,
      
/*17 17 */      7322.05200097,
/*17 15 */      3971.37234407,
/*17 13 */      2170.37459397,
/*17 11 */      1195.00117277,
/*17  9 */       662.77721393,
/*17  7 */       370.18064428,
/*17  5 */       208.12025781,
/*17  3 */       117.69358468,
/*17  1 */        66.86549725,
      
/*18 18 */     12815.11832419,
/*18 16 */      6946.62817478,
/*18 14 */      3792.67511208,
/*18 12 */      2085.48103427,
/*18 10 */      1154.80256799,
/*18  8 */       643.83622933,
/*18  6 */       361.31846095,
/*18  4 */       204.01396683,
/*18  2 */       115.81605684,
/*18  0 */        66.02239895,
      
/*19 19 */     22429.06979669,
/*19 17 */     12151.40195277,
/*19 15 */      6628.37887284,
/*19 13 */      3640.25894626,
/*19 11 */      2012.65314386,
/*19  9 */      1120.13054089,
/*19  7 */       627.41675461,
/*19  5 */       353.60032822,
/*19  3 */       200.42245912,
/*19  1 */       114.16748007,
      
/*20 20 */     39255.63250253,
/*20 18 */     21256.92142296,
/*20 16 */     11585.69962448,
/*20 14 */      6355.52852882,
/*20 12 */      3508.85991399,
/*20 10 */      1949.54060297,
/*20  8 */      1089.93726943,
/*20  6 */       613.05364324,
/*20  4 */       346.82047781,
/*20  2 */       197.25540996,
/*20  0 */       112.70864579,
      
/*21 21 */     68706.25490452,
/*21 19 */     37187.42249877,
/*21 17 */     20252.97311713,
/*21 15 */     11098.44160003,
/*21 13 */      6119.26166041,
/*21 11 */      3394.50666444,
/*21  9 */      1894.35684802,
/*21  7 */      1063.42078287,
/*21  5 */       600.38792464,
/*21  3 */       340.81920161,
/*21  1 */       194.44235759,
      
/*22 22 */    120252.68426697,
/*22 20 */     65059.80015747,
/*22 18 */     35408.16651076,
/*22 16 */     19384.61507252,
/*22 14 */     10674.83166547,
/*22 12 */      5912.86207403,
/*22 10 */      3294.15348344,
/*22  8 */      1845.72107408,
/*22  6 */      1039.95753795,
/*22  4 */       589.13899584,
/*22  2 */       335.47094892,
/*22  0 */       191.92743822,
      
/*23 23 */    210473.46661744,
/*23 21 */    113827.83529829,
/*23 19 */     61910.18247385,
/*23 17 */     33863.35518609,
/*23 15 */     18626.95487224,
/*23 13 */     10303.49219401,
/*23 11 */      5731.13153818,
/*23  9 */      3205.42686277,
/*23  7 */      1802.55236561,
/*23  5 */      1019.05583208,
/*23  3 */       579.08412470,
/*23  1 */       330.67542355,
      
/*24 24 */    368386.72504641,
/*24 22 */    199159.78581210,
/*24 20 */    108258.07647267,
/*24 18 */     59166.08446948,
/*24 16 */     32511.04118351,
/*24 14 */     17960.71246504,
/*24 12 */      9975.55854183,
/*24 10 */      5569.99249044,
/*24  8 */      3126.45346250,
/*24  6 */      1763.99183756,
/*24  4 */      1000.32274225,
/*24  2 */       570.04463613,
/*24  0 */       326.35189816,
      
/*25 25 */    644784.06311507,
/*25 23 */    348474.16490795,
/*25 21 */    189318.94007326,
/*25 19 */    103390.05459287,
/*25 17 */     56756.73196326,
/*25 15 */     31318.48407539,
/*25 13 */     17370.72956938,
/*25 11 */      9684.01711397,
/*25  9 */      5426.20129599,
/*25  7 */      3055.73609042,
/*25  5 */      1729.34900219,
/*25  3 */       983.44170252,
/*25  1 */       561.87553868,
      
/*26 26 */   1128568.99577795,
/*26 24 */    609752.75766679,
/*26 22 */    331100.51543027,
/*26 20 */    180692.92236942,
/*26 18 */     99104.04844189,
/*26 16 */     54626.41153166,
/*26 14 */     30259.79049849,
/*26 12 */     16844.96263553,
/*26 10 */      9423.26493863,
/*26  8 */      5297.15540402,
/*26  6 */      2992.06490629,
/*26  4 */      1698.06388710,
/*26  2 */       968.15353954,
/*26  0 */       554.45805058,
      
/*27 27 */   1975354.69697465,
/*27 25 */   1066963.10721037,
/*27 23 */    579100.71560425,
/*27 21 */    315830.65536621,
/*27 19 */    173078.92226417,
/*27 17 */     95305.31825568,
/*27 15 */     52730.89750357,
/*27 13 */     29314.26318796,
/*27 11 */     16373.72927030,
/*27  9 */      9188.77046199,
/*27  7 */      5180.73675598,
/*27  5 */      2934.45333483,
/*27  3 */      1669.67687313,
/*27  1 */       954.24534827,
      
/*28 28 */   3457520.41256304,
/*28 26 */   1867053.01612374,
/*28 24 */   1012917.55129235,
/*28 22 */    552093.79951938,
/*28 20 */    302320.56195975,
/*28 18 */    166315.47419874,
/*28 16 */     91918.08582754,
/*28 14 */     51034.55289434,
/*28 12 */     28465.14788042,
/*28 10 */     15949.15501282,
/*28  8 */      8976.83959653,
/*28  6 */      5075.21028599,
/*28  4 */      2882.08737384,
/*28  2 */      1643.80745581,
/*28  0 */       941.54030665,
      
/*29 29 */   6051833.02942443,
/*29 27 */   3267187.79959807,
/*29 25 */   1771809.84938599,
/*29 23 */    965188.95962711,
/*29 21 */    528147.13118377,
/*29 19 */    290295.08313405,
/*29 17 */    160272.93386251,
/*29 15 */     88881.13962162,
/*29 13 */     49508.48382769,
/*29 11 */     27698.80600321,
/*29  9 */     15564.79690005,
/*29  7 */      8784.42479461,
/*29  5 */      4979.14074001,
/*29  3 */      2834.29105497,
/*29  1 */      1620.13912705,
                             
/*30 30 */  10592817.78621209,
/*30 28 */   5717428.77725664,
/*30 26 */   3099424.45940474,
/*30 24 */   1687519.33227144,
/*30 22 */    922783.36118012,
/*30 20 */    506791.29180335,
/*30 18 */    279531.72211356,
/*30 16 */    154845.89692330,
/*30 14 */     86144.47949931,
/*30 12 */     48128.98388901,
/*30 10 */     27003.99083037,
/*30  8 */     15215.31424369,
/*30  6 */      8609.00091870,
/*30  4 */      4891.33013407,
/*30  2 */      2790.49960453,
/*30  0 */      1598.40495156 };

   

static double zero_start [] = {
/* 2  2 */    8.31463546,
/* 2  0 */    2.40568006,
          
/* 3  3 */   12.11786516, 
/* 3  1 */    5.45193196, 
                      
/* 4  4 */   14.47907722, 
/* 4  2 */    8.31463531, 
/* 4  0 */    4.28324011, 
                      
/* 5  5 */   16.07284870,
/* 5  3 */   10.46318109, 
/* 5  1 */    6.50325699, 
                      
/* 6  6 */   17.21719206, 
/* 6  4 */   12.11786522, 
/* 6  2 */    8.31463528, 
/* 6  0 */    5.45193195, 
                      
/* 7  7 */   18.07743436,
/* 7  5 */   13.42436464,
/* 7  3 */    9.81093239, 
/* 7  1 */    6.99016039, 
                      
/* 8  8 */   18.74717678, 
/* 8  6 */   14.47907722, 
/* 8  4 */   11.06116163, 
/* 8  2 */    8.31463528, 
/* 8  0 */    6.09563992,
                      
/* 9  9 */   19.28315927, 
/* 9  7 */   15.34694959, 
/* 9  5 */   12.11786516, 
/* 9  3 */    9.46231103, 
/* 9  1 */    7.27085118, 
                      
/*10 10 */   19.72169825, 
/*10  8 */   16.07284854,
/*10  6 */   13.02081465,
/*10  4 */   10.46318088, 
/*10  2 */    8.31463531, 
/*10  0 */    6.50325692, 
                      
/*11 11 */   20.08709083, 
/*11  9 */   16.68856993, 
/*11  7 */   13.80019002, 
/*11  5 */   11.34173513,
/*11  3 */    9.24539483, 
/*11  1 */    7.45340600, 
                      
/*12 12 */   20.39619323, 
/*12 10 */   17.21719206, 
/*12  8 */   14.47907722, 
/*12  6 */   12.11786522, 
/*12  4 */   10.07876986,
/*12  2 */    8.31463531, 
/*12  0 */    6.78447349, 
                      
/*13 13 */   20.66106291, 
/*13 11 */   17.67583228, 
/*13  9 */   15.07532680, 
/*13  7 */   12.80770340, 
/*13  5 */   10.82807300, 
/*13  3 */    9.09742286,
/*13  1 */    7.58162265, 
                      
/*14 14 */   20.89054546, 
/*14 12 */   18.07743445, 
/*14 10 */   15.60290176, 
/*14  8 */   13.42436458, 
/*14  6 */   11.50458990, 
/*14  4 */    9.81093224, 
/*14  2 */    8.31463528,
/*14  0 */    6.99016049, 
                      
/*15 15 */   21.09128079, 
/*15 13 */   18.43195536, 
/*15 11 */   16.07284870, 
/*15  9 */   13.97855769, 
/*15  7 */   12.11786516, 
/*15  5 */   10.46318109, 
/*15  3 */    8.99003823,
/*15  1 */    7.67661538, 
                      
/*16 16 */   21.26834624, 
/*16 14 */   18.74717678, 
/*16 12 */   16.49400255, 
/*16 10 */   14.47907722, 
/*16  8 */   12.67597134, 
/*16  6 */   11.06116163, 
/*16  4 */    9.61365389,
/*16  2 */    8.31463535, 
/*16  0 */    7.14713013, 
                      
/*17 17 */   21.42569284, 
/*17 15 */   19.02926375, 
/*17 13 */   16.87350761, 
/*17 11 */   14.93319192, 
/*17  9 */   13.18574839, 
/*17  7 */   11.61095919,
/*17  5 */   10.19067671, 
/*17  3 */    8.90855803, 
/*17  1 */    7.74981531, 
                      
/*18 18 */   21.56643659, 
/*18 16 */   19.28315927, 
/*18 14 */   17.21719212, 
/*18 12 */   15.34694961, 
/*18 10 */   13.65300705,
/*18  8 */   12.11786522, 
/*18  6 */   10.72572909, 
/*18  4 */   10.72572909, 
/*18  2 */    8.31463528, 
/*18  0 */    7.27085118, 
                      
/*19 19 */   21.69307189, 
/*19 17 */   19.51287508, 
/*19 15 */   17.52985854,
/*19 13 */   15.72541299, 
/*19 11 */   14.08270275, 
/*19  9 */   12.58648068, 
/*19  7 */   11.22291766, 
/*19  5 */    9.97944797, 
/*19  3 */    8.84461904, 
/*19  1 */    7.80794897, 
                      
/*20 20 */   21.80761773,
/*20 18 */   19.72169825,
/*20 16 */   17.81549364,
/*20 14 */   16.07284854,
/*20 12 */   14.47907722,
/*20 10 */   13.02081465,
/*20  8 */   11.68588594,
/*20  6 */   10.46318088, 
/*20  4 */    9.34253878, 
/*20  2 */    8.31463528, 
/*20  0 */    7.37087217, 
                      
/*21 21 */   21.91172559, 
/*21 19 */   19.91234684, 
/*21 17 */   18.07743436, 
/*21 15 */   16.39287315,
/*21 13 */   14.84577571,
/*21 11 */   13.42436448,
/*21  9 */   12.11786516,
/*21  7 */   10.91640671,
/*21  5 */    9.81093224,
/*21  3 */    8.79310727,
/*21  1 */    7.85523391,
                      
/*22 22 */   22.00675982, 
/*22 20 */   20.08709069, 
/*22 18 */   18.31849472, 
/*22 16 */   16.68857007, 
/*22 14 */   15.18594605, 
/*22 12 */   13.80019002, 
/*22 10 */   12.52172209, 
/*22  8 */   11.34173513,
/*22  6 */   10.25212009,
/*22  4 */    9.24539483,
/*22  2 */    8.31463535,
/*22  0 */    7.45340586,
                      
/*23 23 */   22.09385515, 
/*23 21 */   20.24783460, 
/*23 19 */   18.54106299, 
/*23 17 */   16.96258370, 
/*23 15 */   15.50231503, 
/*23 13 */   14.15097365, 
/*23 11 */   12.90000480, 
/*23  9 */   11.74151604,
/*23  7 */   10.66821942,
/*23  5 */    9.67337259,
/*23  3 */    8.75072129,
/*23  1 */    7.89444707,
                      
/*24 24 */   22.17396691, 
/*24 22 */   20.39619323, 
/*24 20 */   18.74717744, 
/*24 18 */   17.21719206, 
/*24 16 */   15.79725799, 
/*24 14 */   14.47907722, 
/*24 12 */   13.25497848, 
/*24 10 */   12.11786522,
/*24  8 */   11.06116163,
/*24  6 */   10.07876986,
/*24  4 */    9.16502181,
/*24  2 */    8.31463528,
/*24  0 */    7.52266886,
                      
/*25 25 */   22.24790193, 
/*25 23 */   20.53354264, 
/*25 21 */   18.93858961, 
/*25 19 */   17.45436951, 
/*25 17 */   16.07284870, 
/*25 15 */   14.78658085, 
/*25 13 */   13.58866306, 
/*25 11 */   12.47268784,
/*25  9 */   11.43270513,
/*25  7 */   10.46318109,
/*25  5 */    9.55896077,
/*25  3 */    8.71523338,
/*25  1 */    7.92749293,
                      
/*26 26 */   22.31634843, 
/*26 24 */   20.66106291, 
/*26 22 */   19.11681316, 
/*26 20 */   17.67583232, 
/*26 18 */   16.33090596, 
/*26 16 */   15.07532687, 
/*26 14 */   13.90286007, 
/*26 12 */   12.80770330,
/*26 10 */   11.78445311,
/*26  8 */   10.82807300,
/*26  6 */    9.93386173,
/*26  4 */    9.09742293,
/*26  2 */    8.31463535,
/*26  0 */    7.58162264,
                     
/*27 27 */   22.37989532, 
/*27 25 */   20.77976904, 
/*27 23 */   19.28315927, 
/*27 21 */   17.88308193, 
/*27 19 */   16.57303231, 
/*27 17 */   15.34694975, 
/*27 15 */   14.19918326, 
/*27 13 */   13.12446180,
/*27 11 */   12.11786516,
/*27  9 */   11.17479552,
/*27  7 */   10.29095362,
/*27  5 */    9.46231103,
/*27  3 */    8.68508624,
/*27  1 */    7.95572026,
                      
/*28 28 */   22.43904935, 
/*28 26 */   20.89054546, 
/*28 24 */   19.43877402, 
/*28 22 */   18.07743445, 
/*28 20 */   16.80064222, 
/*28 18 */   15.60290176, 
/*28 16 */   14.47907722, 
/*28 14 */   13.42436464,
/*28 12 */   12.43427091,
/*28 10 */   11.50458977,
/*28  8 */   10.63137696,
/*28  6 */    9.81093224,
/*28  4 */    9.03977763,
/*28  2 */    8.31463528,
/*28  0 */    7.63240913,
                      
/*29 29 */   22.49425116, 
/*29 27 */   20.99415863, 
/*29 25 */   19.58465938, 
/*29 23 */   18.26005012, 
/*29 21 */   17.01499024, 
/*29 19 */   15.84448163, 
/*29 17 */   14.74384069, 
/*29 15 */   13.70868046,
/*29 13 */   12.73488554,
/*29 11 */   11.81859614,
/*29  9 */   10.95618881,
/*29  7 */   10.14425447,
/*29  5 */    9.37958633,
/*29  3 */    8.65915867,
/*29  1 */    7.98011142,
                      
/*30 30 */   22.54588447, 
/*30 28 */   21.09128079, 
/*30 26 */   19.72169825, 
/*30 24 */   18.43195523, 
/*30 22 */   17.21719212, 
/*30 20 */   16.07284854, 
/*30 18 */   14.99464302, 
/*30 16 */   13.97855769, 
/*30 14 */   13.02081465,
/*30 12 */   12.11786522,
/*30 10 */   11.26636850,
/*30  8 */   10.46318088,
/*30  6 */    9.70533748,
/*30  4 */    8.99003834,
/*30  2 */    8.31463528,
/*30  0 */    7.67661537  };

        t_handle          R;
        
        t_real          param1,param2,lambda,start,step;
        integer_small   n,r1,i;
        t_logical         ok;
       
   if (!order_reals_known (ord))
     order_reals (ord) = real_str_create (30);



   n  = order_abs_degree (ord);
   r1 = order_r1 (ord);
   R  =  order_reals (ord);                     
                                   




/* Index formula for position of (n,r1) in array def. in fincke_gamma_values */
   i = no_sig_less_n (n) + (n/2) - (r1/2);
           



   param1 = conv_double_to_real (R,gamma_opt [i]);
   param2 = conv_double_to_real (R,(double) (2.0/(1.0*n))); 

   start  = conv_double_to_real (R,zero_start [i]-0.01);
   step   = conv_double_to_real (R,0.1);


   ok = regula_falsi_zero (R,start,step,&fincke_func,param1,param2,&lambda); 

   
   real_delete (&param2);
   real_delete (&start);
   real_delete (&step);               
   

   if (order_fincke_gamma1_known (ord))
     real_delete (&order_fincke_gamma1 (ord));

   if (order_fincke_lambda_known (ord))
     real_delete (&order_fincke_lambda (ord));

   order_fincke_lambda (ord) = lambda;
   order_fincke_gamma1 (ord) = param1;

}



integer_small 
no_sig_less_n WITH_1_ARG (integer_small , n)
/*******************************************************************************
 
Description:

     We have got an array of certain start values for the ca|culation 
     of the right fincke_lambda.
 
     To find the right values (which depends on the signature of the field)
     we need to know their pos. in the array. This routine computes the number
     of elements with arbitrary signature (r1,r2) and r1+2*r2 <n.
            
     This function is just called by order_fincke_lambda_calc ();
                                                                 

Calling sequence:
      
              integer_small    n;
              integer_small    m;

        m = no_sig_less_n (n);
 

History:
 
	92-06-12 MD     written
 
*******************************************************************************/
{
       integer_small   m,j;

  m = (n-2) / 2; 
  
  j = m*(m+1) + (n/2)*2 - 2;
  
  if ((n %2 ) == 1) 
    j = j + ( n-1)/2 + 1;

  return j;
}

