#include "stdio.h"        
#include "kant.h"
#include "mat.h"
#include "conv.e"
#include "real.e"
#include "conv.e"

matrix
mat_real_to_mat_real WITH_3_ARGS(
	t_handle,		reals1,
	matrix,		mat,
	t_handle,		reals2
)
/*******************************************************************************
 
mat_real_to_mat_real.c
 
JS October 1991
Last modification: 11.10.91

Casts a real matrix into a real matrix with possibly different precision.
 
*******************************************************************************/
{
	integer_small	m, n, i, j;
	matrix		mat2;
                                        
 
	if (real_beta_prec(reals1) == real_beta_prec(reals2))
		return mat_incref(mat);
	
 
        m = mat_row(mat);
        n = mat_col(mat);
 
	mat2 = mat_new(m, n);
                                  
	for (i=1; i<=m; ++i)
	{
		{
		for (j=1; j<=n; ++j)
		    mat_elt(mat2, i, j) = conv_real_to_real
					  (mat_elt(mat, i, j), reals1, reals2);
		}
	}
 
	return mat2;
}
