/******************************************************************************
  lat_shortest_vector.c 
******************************************************************************/

#include "kant.h"
#include "mat.h"
#include "lattice.h"

lat_elt
lat_shortest_vector WITH_3_ARGS (
	lattice,	lat,
	t_real*,	length,
	t_logical,	prec_flag	
)
/******************************************************************************
 
Description:	Computes the shortest vector in the passed lattice using
		LLL-reduction.
 
Calling sequence:
 
	s_elt = lat_shortest_vector(lat,&length,prec)

	lat_elt		s_elt	= t_handle of lat_elt
	lattice		lat	= t_handle of lattice
	t_real		length	= t_handle of the length of s_elt
	t_logical		prec	= FALSE : enumeration by double arithmetic 
				  TRUE  : enumeration by long arithmetic

History:

	92-03-19 KW	minor changes 
	92-03-09 KW	written
 
******************************************************************************/
{
	block_declarations;

	t_handle		Z;
	integer_small	i,j;
	lat_elt		shortest_vector;
	lattice		llllat;
	lat_enum_env	env;
	matrix		trans,inv_trans;

	llllat = lat_lll_reduce(lat,&trans,&inv_trans);
	if (lat_chol_ring(lat))
	{
		lat_chol_ring(llllat) = ring_incref(lat_chol_ring(lat));
	}

	env = lat_enum_create(llllat);
	lat_enum_request_set_shortest(env);
    	if (prec_flag) lat_enum_precision_set_long(env);
	lat_enum_strategy_set_up(env);

	lat_enum(llllat,env);

	shortest_vector = lat_elt_move(llllat,lat_enum_act_coefs(env),trans);
	*length = real_incref(lat_enum_act_length(env));

	lat_enum_delete(lat,&env);
	lat_delete(&llllat);

	Z = m_z_str_incref(structure_z);
	mat_delref(Z,&trans);
	mat_delref(Z,&inv_trans);
	ring_delete(&Z);	

	return (shortest_vector);
}
