/*******************************************************************************
  integer_matrix_gcd.c
********************************************************************************/

#include "kant.h"     
#include "integer.e"
#include "mat.h"
#include "mat.e"                         



integer_big integer_matrix_gcd WITH_2_ARGS (t_handle , cring,
                                            matrix , mat   )
/*******************************************************************************
Description:               

    Calculates the gcd of all matrix entries of a matrix over the rational
    integers.

                            
Calling sequence:            

           t_handle       cring : The ring corresponding to the matrix mat.
                                Cring has to be a reference to ZZ.
           matrix       mat   : An arbitrary integer matrix
           
           integer_big  gcd   : The kernel of mat a described above.

    
        gcd = integer_matrix_gcd (cring,mat);

                                                                     
History:  
                                                               
       MD 91-12-10        : first version                
  
********************************************************************************/
{
       block_declarations;
  
       integer_small i,j,n,m;
       integer_big   gcd,temp;
  
                       
  if (ring_type (cring) == RING_Z) 
  {
    

    n = mat_row (mat);
    m = mat_col (mat);
        
    gcd = 0;             

    for (i=1;i<=n;i++)
      for (j=1;j<=m;j++)
      {
        temp = gcd;
        gcd = integer_gcd (mat_elt(mat,i,j),temp);
        integer_delref (temp);
        if (gcd == 1) break;
      }

    return gcd;
    
  }
  return -1;
}

