#include "kant.h"
#include "poly.h"
#include "dyn_arr.h"

t_poly
dyn_arr_to_poly WITH_2_ARGS(
	t_handle,		cring,
	dyn_arr_handle,	arr
)
/*******************************************************************************
 
dyn_arr_to_poly.c
 
JS October 1991 
Last modification: 21.10.91
 
Casts elements of an array into a polynomial, assuming that the elements
of the array are coefficients of a polynomial whith increasing exponents,
starting with 0 and being incremented by 1.
 
*******************************************************************************/
{
	block_declarations;         
 
	t_poly	pol;
	integer_small	i, nt;
	t_handle	pring, res;
 
	nt = dyn_arr_curr_length(arr);
 
	m_poly_u_create_empty(&pol, nt);
 
	for (i=0; i<nt; ++i)
	{
		m_poly_coefft(pol, i) = ring_elt_incref(cring, 
				      dyn_arr_element(arr, i));
		m_poly_expt(pol, i)   = i;
	}

	pring = poly_str_create(cring, 1);
	res =  poly_clean(pring, m_poly_handle_to_poly(pol));
	poly_str_delete(0, &pring);
	return res;
}
