/******************************************************************************
  anf_ideal_tran_assure_hnf_upper.c
******************************************************************************/
 
#include "stdio.h"        
#include "kant.h"
#include "mat.h"
#include "anf.h"

t_void
anf_ideal_tran_assure_hnf_upper WITH_2_ARGS(
	order,		ord,
	anf_ideal,	id
)
/*******************************************************************************
 
Description:
                                                    
	If a given ideal has no transition matrix in upper hnf,
	we compute this upper hnf.
	Further we try to simplify.

  
Calling sequence:
 
        anf_ideal_tran_assure_hnf_upper(ord, id);
 
        order   	ord:     	 order over which id is defined
        anf_ideal        id:    	 ideal to have transition matrix in upper hnf

 
History:
 
	92-05-20 CO     first version

*******************************************************************************/
{       
	block_declarations;
 
	t_handle		z;
	matrix		hnf;                  

 
	order_must_be_over_z(ord);


/*******  compute Z-Basis-Presentation if not given yet  *******/

	anf_ideal_z_assure( ord, id );

/*******  compute upper hnf if not given yet  *******/

	if( !anf_ideal_tran_is_upper_hnf(id) )
	{       
		hnf = mat_ring_hnf_col_upper( order_coef_order(ord), anf_ideal_tran(id) );
		mat_delref( order_coef_order(ord), &anf_ideal_tran(id) );
		anf_ideal_tran(id) = hnf;		
		anf_ideal_tran_hnf(id) = 1;
	}          
                                               
/*******  simplify  *******/

	z = m_z_str_incref(structure_z);                 
	mat_z_simplify ( z, anf_ideal_tran(id), &anf_ideal_tran_den(id) );           
	ring_delete(&z);
}
