/******************************************************************************
  anf_elt_subtract.c                                                           
******************************************************************************/
                 
#include "kant.h"

anf_elt
anf_elt_subtract WITH_3_ARGS(
	order,		ord,
	anf_elt,	alpha,
	anf_elt,	beta
)
/*******************************************************************************
 
Description:
 
	Subtracts beta from alpha.
 
  
Calling sequence:
 
	gamma = anf_elt_subtract(ord, alpha, beta);
 
      	order       ord   = t_handle of order alpha, beta are given referring to
        anf_elt     alpha = algebraic number 
        anf_elt     beta  = algebraic number 
        anf_elt     gamma = algebraic number difference
     
History:
 
	92-09-07 JS    first version

*******************************************************************************/
{       
	block_declarations;
 
	anf_elt		beta_minus, gamma;
                                   
        beta_minus = anf_elt_negate(ord, beta);
        gamma      = anf_elt_add(ord, alpha, beta_minus);
 
        anf_elt_delref(ord, &beta_minus);
 
	return gamma;
} 

