;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald sets)

;;; functions to use lists as sets 

(define (IS-SET? set)
  (or (null? set)
      (and (pair? set)
	   (null? (cdr (lastcdr set)))
	   (iterate iter ((set set))
	     (cond ((null? set) '#t)
		   ((memq? (car set) (cdr set))
		    '#f)
		   (else (iter (cdr set))))))))


(define (MAKE-SET lst)
  (if
   (null? lst)
   '()
   (iterate iter ((lst lst) (new-elems nil))
     (cond ((memq? (car lst) (cdr lst))
	    (iter (cdr lst) new-elems))
	   ((is-set? (cdr lst))
	    (append! (reverse! new-elems) lst))
	   (else
	    (iter (cdr lst)
		  (cons (car lst) new-elems)))))))

(define (MAKE-SINGLETON elem)
  (list elem))

(define THE-EMPTY-SET '())

(define EMPTY-SET? null?)

(define FIRST-SET-ELEMENT car)

(define REST-OF-SET cdr)

(define ELEMENT-OF-SET? memq?)

(define (ADD-SET-ELEMENT new-elem the-set)
  (if (memq? new-elem the-set)
      the-set
      (cons new-elem the-set)))

(define (DELETE-SET-ELEMENT former-elem the-set)
  (cond ((null? the-set) the-set)
        ((eq? (car the-set) former-elem)
         (cdr the-set))
        (else
         (let ((rest (delete-set-element former-elem (cdr the-set))))
           (if (eq? rest (cdr the-set))
               the-set
               (cons (car the-set) rest))))))

(define (SUBSET? set1 set2)
  (every?
   (lambda (elem1) (memq? elem1 set2))
   set1))

(define (SUBSET-WITH-PRED? pred set1 set2)
  (every?
   (lambda (elem1) (mem? pred elem1 set2))
   set1))

(define SUBSET-WITH-EQUAL?
  (lambda (set1 set2)
    (subset-with-pred? equal? set1 set2)))

(define (SET-EQUAL? set1 set2)
  (and 
   (subset? set1 set2)
   (subset? set2 set1)))

(define (PROPER-SUBSET? set1 set2)
  (and (subset? set1 set2)
       (not (subset? set2 set1))))

(define (SET-EQUAL-WITH-PRED? pred set1 set2)
  (and 
   (subset-with-pred? pred set1 set2)
   (subset-with-pred? pred set2 set1)))

(define SET-EQUAL-WITH-EQUAL?
  (lambda (set1 set2)
    (set-equal-with-pred? equal? set1 set2)))

(define EQUAL-SETS? set-equal?)

(define CARDINALITY length)

(define EVERY-SET-ELEMENT? EVERY?)

(define ANY-SET-ELEMENT? any?)

(define (SET-MAP proc set)
  (make-set (map proc set)))

(define (SET-WALK proc set)
  (walk proc set))

(define (SET-UNION set2 set1)
  (iterate iter ((set2 set2)
		 (new '()))
    (cond ((null? set2) (append! (reverse! new) set1)) 
	  ((memq? (car set2) set1)
	   (iter (cdr set2) new))
	  (else
	   (iter (cdr set2)
		 (cons (car set2) new))))))

(define (SET-INTERSECTION set1 set2)
  (if
   (null? set2)
   nil
   (iterate iter ((set1 set1) (already nil))
     (cond ((null? set1) (reverse! already))
	   ((memq? (car set1) set2)
	    (iter (cdr set1)
		  (cons (car set1)
			already)))
	   (else
	    (iter (cdr set1) already))))))

(define (NULL-INTERSECTION? set1 set2)
  (or
   (null? set2)
   (iterate iter ((set1 set1)(set2 set2))
     (cond ((null? set1))
	   ((memq? (car set1) set2) '#f)
	   (else
	    (iter (cdr set1) set2))))))

(define (NON-NULL-INTERSECTION? set1 set2)
  (not (null-intersection? set1 set2)))

(define (SET-DIFF set1 set2)
  (if
   (null? set2)
   set1
   (iterate iter ((set1 set1) (already nil))
     (cond ((null? set1) (reverse! already))
	   ((memq? (car set1) set2)
	    (iter (cdr set1) already))
	   (else
	    (iter (cdr set1)
		  (cons (car set1) already)))))))

(define SET-DIFFERENCE set-diff)

(define (SET-SEPARATE filter? set)
  (iterate iter ((set set) (already the-empty-set))
    (cond ((empty-set? set) (reverse! already))
	  ((filter? (first-set-element set))
	   (iter (rest-of-set set)
		 (cons (first-set-element set) already)))
	  (else
	   (iter (rest-of-set set)
		 already)))))

(define SEPARATE-SET set-separate)

(define (SET-SPLIT filter? set)
  (iterate iter ((set set)
		 (ins the-empty-set)
		 (outs the-empty-set))
    (cond ((empty-set? set) (return ins outs))
	  ((filter? (first-set-element set))
	   (iter (rest-of-set set)
		 (add-set-element (first-set-element set) ins)
		 outs))
	  (else
	   (iter (rest-of-set set)
		 ins
		 (add-set-element (first-set-element set) outs))))))


(define (SELECT-SET-ELEMENT predicate? set)
  (cond ((empty-set? set) (return '#F '#F))
	((predicate? (first-set-element set))
	 (return '#T (first-set-element set)))
	(else
	 (select-set-element predicate? (rest-of-set set)))))

(define (BIG-U family-of-sets)
  (iterate iter ((family family-of-sets) (union-so-far nil))
    (if (null? family)
	(reverse! union-so-far)
	(iter (cdr family)
	      (set-union (car family) union-so-far)))))

(define (BIG-CAP family-of-sets)
  (if (null? family-of-sets)
      (error "BIG-CAP: Null family.")
      (iterate iter ((family (cdr family-of-sets))
		     (intersection-so-far (car family-of-sets)))
	(if (null? family)
	    intersection-so-far
	    (iter (cdr family)
		  (set-intersection (car family) intersection-so-far))))))

;;; Return the union of sets of the form (PROC S) for S in SOURCES

(define (COLLECT-SET proc sources)
  (and
   sources
   (do ((rem (cdr sources)(cdr rem))
	(total (proc (car sources)) (append (proc (car rem)) total)))
       ((null? rem)
	(make-set
	 total)))))

;;; CONTAINING-SET returns the set in FAMILY that contains ELEM

(define (CONTAINING-SET family elem)
  (iterate iter ((family family))
    (cond ((null? family) '#f)
	  ((memq? elem (car family))
	   (car family))
	  (else (iter (cdr family))))))

;;; Suppose that A and B are partitions, that is to say, each is a family of
;;; pairwise disjoint sets.  MERGE-PARTITIONS returns a partition C such that
;;; 1. U(C) = U(A) u U(B)
;;; 2. x, y in D and D in A => some D', x, y in D' and D' in C.
;;; 3. x, y in D and D in B => some D', x, y in D' and D' in C.
;;; 4. C is the finest partition satsifying 1, 2, 3.
;;; 

(define (MAKE-PARTITION family)
  (iterate iter ((family family)
		 (partition nil))
    (cond ((null? family) partition)
	  ((any
	    (lambda (p-s)
	      (and (non-null-intersection? (car family) p-s)
		   p-s))
	    partition)
	   =>
	   (lambda (p-s)
	     (iter (cdr family)
		   (cons (set-union (car family) p-s)
			 (delq! p-s partition)))))
	  (else
	   (iter (cdr family)
		 (cons (car family) partition))))))

(define (MERGE-PARTITIONS A B)
  (make-partition (append a b)))    

;;; Given a set A and an equivalence-relation equiv-rel?, PARTITION-SET returns
;;; a family B of sets, such that the union of B is A, and two elements are in the
;;; same member of B iff equiv-rel? holds true for them.  

(define (PARTITION-SET the-set equiv-rel?)
  (iterate step-through ((the-set the-set) (family nil))
    (if
     (null? the-set)
     (reverse! (map! (lambda (l)
		       (reverse! l))
		     family))
     (let ((elem (car the-set)))
       (cond ((any
		(lambda (class)
		  (and (equiv-rel? elem (car class))
		       class))
		family)
	       =>
	       (lambda (class)
		 (step-through (cdr the-set)
			       (if (memq? elem class)
				   family
				   (cons
				    (cons elem class)
				    (delq! class family))))))
	     (else 
	      (step-through (cdr the-set)
			    (cons
			     (list elem)
			     family))))))))

;;; MERGE-PARTITION-CLASSES, applied to a partition and two sets within it
;;; returns a partition differing from the first in that those two elements
;;; have been joined.  

(define (MERGE-PARTITION-CLASSES partition set1 set2)
  (if (and (memq? set1 partition)
	   (memq? set2 partition))
      (add-set-element
       (set-union set1 set2)
       (set-diff partition (list set1 set2)))
      (error "MERGE-PARTITION-CLASSES: bogus partition elements.")))

;;; Given a partition, a class within it, and an object, return a partition
;;; differing in that the object has been added to that class.  

(define (ADD-ELEMENT-TO-PARTITION-CLASS partition class element)
  (add-set-element
   (add-set-element element class)
   (delete-set-element class partition)))


;;; set-tables -- that is to say, tables with sets as their keys, so that the
;;; appropriate comparator is equal-sets? and the type is is-set?

(define (MAKE-SET-TABLE . maybe-id)
  (apply make-hash-table
	 is-set? set-hash
	 equal-sets? '#t maybe-id))

(define (SET-TABLE? table)
  (and (hash-table? table)
       (eq? is-set?
	    ((*value t-implementation-env '%table-type) table))
       (eq? set-hash ((*value t-implementation-env '%table-hash) table))
       (eq? equal-sets? ((*value t-implementation-env '%table-compare) table))))

;;; If TABLE is a table, with eq? as comparator, construct a set containing
;;; those values which occur with at least one key in TABLE.   

(define (TABLE->SET the-table)
  (let ((the-set nil))
    (walk-table
     (lambda (key value)
       (ignore key)
       (set the-set (add-set-element value the-set)))
     the-table)
    the-set))

(import t-implementation-env descriptor-hash)

(define (set-hash s)
  (iterate iter ((hash-val 0)
		 (s s))
    (if (null? s)
	hash-val
	(iter 
	 (fx+ hash-val (descriptor-hash (car s)))
	 (cdr s)))))

(define (alternate-set-hash s)
  (iterate iter ((hash-val 1)
		 (s s))
    (if (null? s)
	hash-val
	(iter 
	 (fixnum-remainder
	  (* hash-val
	     (fixnum-remainder (descriptor-hash (car s))
			       12791))			;two convenient prime 
	  12799)					;numbers  
	 (cdr s)))))

(*require nil '(resources lisp-supplements) imps-implementation-env)

'sets

;;; 
