;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald emacs-buffers)

(lset emacs-output (standard-output))

(define emacs-eval-start 	#[Char 29])
(define emacs-eval-end 		#[Char 30])
(define emacs-uneval-start 	#[Char 31])

(define emacs-eval-start-str 	(char->string emacs-eval-start))
(define emacs-eval-end-str 	(char->string emacs-eval-end))
(define emacs-uneval-start-str 	(char->string emacs-uneval-start))

(define emacs-process-filter?
  (make-simple-switch 'emacs-process-filter? boolean? '#f))

(define (set-emacs-process-filter)
  (set (emacs-process-filter?) '#t)
  (format '#t ";; Emacs-process-filter now on.")
  repl-wont-print)

(define (unset-emacs-process-filter)
  (set (emacs-process-filter?) '#f)
  (format '#t ";; Emacs-process-filter now off.")
  repl-wont-print)

(define (emacs-buffer-eval buffname str . args)
  (apply emacs-eval
	 (format nil "(progn (set-buffer ~S) ~A)"
		 buffname str)
	 args))



(define (emacs-eval str . args)
  (if (emacs-process-filter?)
      (block 
	(apply format emacs-output
	       (string-append emacs-eval-start-str
			      str
			      emacs-eval-end-str)
	       args)
	(force-output emacs-output)
	repl-wont-print)
      (imps-warning
       "Emacs-eval: wanted emacs to execute ~S~%Emacs process-filter not on.~%~%"
       (apply format nil str args))))

(define (emacs-apply-to-string fn-part unevalled-str)
  (emacs-eval
   (format nil "~A~A~A"
	   fn-part
	   emacs-uneval-start
	   unevalled-str)))

(define (emacs-buffer-apply-to-string buffname fn-part unevalled-str)
  (emacs-eval
   (format nil "(lambda (str) (set-buffer ~S) (funcall ~A str))~A~A"
	   buffname
	   fn-part
	   emacs-uneval-start
	   unevalled-str)))

(define (emacs-message format-str . args)
  (emacs-eval
   (format '#f "(message ~S \"~A\")"
	   format-str
	   (separated-string-append "\" \"" args))))

(define (emacs-error str)
  (emacs-eval
   (format '#f "(imps-error ~S)" str)))


(define (get-line-from-emacs buffname)
  (emacs-eval "(read-line-from-tea-buff ~S)" buffname)
  (read-line (standard-input)))

(define (read-succeeding-line stream)
  (read-line stream)
  (read-line stream))

(define (blank? str)
  (cond ((string-empty? str) '#t)
	((not (whitespace? (char str))) '#f)
	(else
	 (blank? (chdr str)))))
      
(define (read-emacs-communication read-fn)
  (emacs-eval "(process-read tea-process)")
  (read-fn (standard-input)))

(define (emacs-write buffname str)
  (emacs-buffer-apply-to-string
   buffname
   "'(lambda (str)(save-excursion
		   (let ((buffer-read-only nil))
		     (goto-char (point-max))
		     (insert str))))"
   str))

(define gc-start-message
  (string-append emacs-eval-start-str
		 "(tea-start-gc)" 
		 emacs-eval-end-str))
(define gc-finish-message
  (string-append emacs-eval-start-str
		 "(tea-finish-gc)" 
		 emacs-eval-end-str))

(define (gc-start-tell-emacs)
  (if (emacs-process-filter?)
      (block (display gc-start-message emacs-output)
	     (force-output emacs-output))))
(define (gc-finish-tell-emacs)
  (if (emacs-process-filter?)
      (block (display gc-finish-message emacs-output)
	     (force-output emacs-output))))

(push (*value t-implementation-env '*pre-gc-agenda*) gc-start-tell-emacs)
(push (*value t-implementation-env '*post-gc-agenda*) gc-finish-tell-emacs)

(define-operation reset-emacs-port)
(define-operation set-write-string-force-length)
(define-operation emacs-port-eval)

;; NAME is a string here. 
(define (emacs-port name . restriction)
  (let ((unwriteable? (eq? (car restriction) 'in))
	(unreadable? (eq? (car restriction) 'out)))
    (emacs-eval "(get-new-tea-buffer ~S)" name)
    (emacs-eval "(progn (set-buffer ~S) (erase-buffer)(tea-buff-mode))" name)
    (let* ((read-table standard-read-table)
	   (current-read-string "")
	   (current-write-string "")
	   (write-string-force-length 10)
	   (newline? '#f)
	   (last-read '#f)
	   (pre-write
	    (lambda (self object printer-fn)
	      (let ((printed-rep
		     (with-output-to-string tmp (printer-fn object tmp))))
		(set current-write-string
		     (string-append current-write-string printed-rep))
		(if (> (string-length current-write-string)
		       write-string-force-length)
		    (force-output self)
		    (return))))))

      (object
	  nil
	((port? self) '#t)
	((input-port? self) (not unreadable?))
	((output-port? self) (not unwriteable?))
	((interactive-port? self) '#t)

	((port-read-table self) read-table)
	(((setter port-read-table) self new-r-t)
	 (set read-table new-r-t))

	((set-write-string-force-length self new-value)
	 (set write-string-force-length
	      (enforce fixnum? new-value)))

	((read-char self)
	 (cond (unreadable? (error "Port ~A not for input." name))
	       ((and newline? (string-empty? current-read-string))
		(set newline? '#f)
		(set last-read #\newline)
		#\newline)
	       ((string-empty? current-read-string)
		(set current-read-string
		     (get-line-from-emacs name))
		(set newline? '#t)
		(read-char self))
	       ((string-equal? "*eof*" current-read-string)
		(set current-read-string "")
		(set last-read '#f)
		*eof*)
	       (else
		(let ((ch 
		       (char
			(swap current-read-string (string-tail current-read-string)))))
		  (set last-read ch)
		  ch))))

	((unread-char self)
	 (cond (last-read
		(set current-read-string
		     (string-append
		      (char->string (swap last-read '#f))
		      current-read-string))
		(return))
	       (else 
		(error
		 "consecutive attempt to UNREAD-CHAR on ~A" name))))
	     

	((read-line self)
	 (cond (unreadable? (error "Port ~A not for input." name))
	       ((or (string-empty? current-read-string)
		    (and (char= (char current-read-string)
				#\newline)
			 (= 1 (string-length current-read-string))))
		(let ((str (get-line-from-emacs name)))
		  (if (string-equal? "*eof*" str)
		      *eof*
		      str)))
	       ((string-equal? "*eof*" current-read-string)
		*eof*)
	       (else
		(set newline? '#f)
		(swap current-read-string ""))))

	((reset-emacs-port self)
	 (if unwriteable?
	     (emacs-eval "(reset-tea-buff-marker ~S)" name)
	     (emacs-eval "(clear-tea-buff ~S)" name))
	 (return))

	((force-output self)
	 (if unwriteable? (error "Port ~A not for output." name))
	 (emacs-write name (swap current-write-string ""))
	 (force-output emacs-output))
	
	((write self object)
	 (if unwriteable? (error "Port ~A not for output." name))
	 (pre-write self object print))

	((write-char self chr)
	 (if unwriteable? (error "Port ~A not for output." name))
	 (enforce char? chr)
	 (pre-write self chr display))

	((write-string self str)
	 (enforce string? str)
	 (pre-write self str display))

	((emacs-port-eval self str . args)
	 (apply emacs-buffer-eval name str args))))))

     

    


;;;(define (assemble-unevalled strs)
;;;  (if
;;;   (null? strs)
;;;   ""
;;;   (let ((sep (char->string #\))
;;;	 (get-the-str
;;;	  (lambda (s)
;;;	    (if (string? s) s (format nil "~A" s)))))
;;;	(iterate iter ((strs (cdr strs))
;;;		    (assembled-str (get-the-str (car strs))))
;;;	  (if (null? strs) assembled-str
;;;	   (iter (cdr strs)
;;;		 (string-append assembled-str sep (get-the-str (car strs)))))))))

;;;
;;;	((read self)
;;;	 (if unreadable? (error "Port ~A not for input." name))
;;;	 (let ((back-up (string-length current-read-string)))
;;;	   (set current-read-string "")
;;;	   (emacs-eval
;;;	    "(progn (set-buffer ~S)
;;;		     (read-sexp-from-tea-buff (current-buffer) ~D))" name back-up))
;;;	 (let ((val (read (standard-input))))
;;;	   (if (eq? '*eof* val)
;;;	       *eof*
;;;	       val)))
;;;
