;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994

(herald sounds)

(define (dg-sound-effect sound) 
  (set (command-or-script-current-node) (cons (car (command-or-script-current-node)) '#t))
  (emacs-eval (format nil "(playsound \"~A\")" sound)))

(define (DEDUCTION-GRAPH-INFER rule sqns dg)
  (let ((real-rule (->rule rule))
	(grounded-to-start (deduction-graph-grounded? dg)))
    (block0
     (if (not ((rule-soundness-predicate real-rule)
	       (deduction-graph-theory dg)))
	 (fail)
	 (let ((inf (real-rule
		     (map (lambda (sqn) (and (sequent-node? sqn)
					     (sequent-node-sequent sqn)))
			  sqns))))
	   (if (inference? inf)
	       (post-inference inf dg)
	       (fail))))
     (do-special-effects dg grounded-to-start)
     )))

(define (sound-effect-already?)
  (and (command-or-script-current-node)
       (cdr (command-or-script-current-node))))

(lset *avoid-sound-effects* nil)

(define (toggle-special-effects)
  (set *avoid-sound-effects* (not *avoid-sound-effects*)))

(define (do-special-effects dg grounded-to-start)
  (or *avoid-sound-effects*
      grounded-to-start
      (sound-effect-already?)
      (if (deduction-graph-grounded? dg)
	  (dg-sound-effect "gong")
	  (if (and (command-or-script-current-node)
		   (immediately-grounded? (car (command-or-script-current-node))))
	      (dg-sound-effect "cowbell")))))

(define command-or-script-current-node
  (make-simple-switch 'command-or-script-current-node
		      (lambda (x) (or (false? x)
				      (and (list? x)
					   (sequent-node? (car x)))))
		      '#f))


;;Trivial modifications of existing procedures

(define (START-DEDUCTION goal theory)			
  ;goal a seq
  (let ((dg (make-deduction-graph)))
    (set (command-or-script-current-node) '#f)

    ;; This modification is necessary just in case a command or a script
    ;; was interrupted during execution prior to beginning a new deduction.

    (set (deduction-graph-theory dg) theory)
    (if goal
	(set (deduction-graph-goal dg)			
	     (post goal dg)))				
    (push *dgs* dg)
    (reset-current-dg)
    dg))


(define (interpret-command-sequence sqn command-applier display command-script)
        
  ;;Each entry in the command script is
  
  ;; (a) The name of a single proof command.
  ;; (b) A list (proof-command-name args)
  ;; (c) A list (control-command-name args)
  (bind (((imps-raise-error?) '#f)
	 ((command-or-script-current-node) (or (command-or-script-current-node) (cons sqn '#f))))
    (let ((goal sqn)
	   ;;
	   ;; (dg (sequent-node-graph sqn))
	  )
      (iterate loop ((sqn goal) (command-script command-script))
	(cond ((immediately-grounded? goal)		; Grounded so stop!
	       (return (immediately-grounded? goal) sqn))
	      ((or (null? command-script)		; No more commands left
		   (not (sequent-node? sqn)))		; Sqn isn't a sequent node 
	       (return (immediately-grounded? goal) sqn))
	      ((symbol? (car command-script))

	       ;;If the expression is a symbol evaluate it

	       (let ((evaled 
		      (interpret-command-argument sqn display (car command-script))))
		 (if (list? evaled)
		     (command-applier sqn (car evaled) (cdr evaled))
		     (command-applier sqn evaled '())))
	       (loop
		(sequent-node-first-unsupported-relative sqn)
		(cdr command-script)))
	      ((command-sequence-keyword? (caar command-script))
	       (loop (interpret-keyword
		      command-applier
		      sqn
		      (caar command-script)
		      display
		      (cdar command-script))
		     (cdr command-script)))
	      (else 
	       (command-applier
		sqn
		(interpret-command-argument sqn display (caar command-script))
		(map
		 (lambda (arg)
		   (interpret-command-argument sqn display arg))
		 (cdar command-script)))
	       (loop
		(sequent-node-first-unsupported-relative sqn)
		(cdr command-script))))))))



(define (imps-congratulation format-string . args)
  (let ((string (apply format '#f format-string args)))
    (if (emacs-process-filter?)
	(emacs-error (string-append "Congratulations: " string)))
    (newline (standard-output))
    (display "IMPS congratulations: " (standard-output))
    (display string (standard-output))
    (newline (standard-output))
    (force-output (standard-output))))


(define (DEDUCTION-GRAPH-APPLY-COMMAND-INTERFACE
	 dg-or-number
	 command-or-name
	 sqn-data
	 aux
	 comments)
  (bind (((raise-name-error?) '#t))
    (if (null? sqn-data)
	'#f
	(let* ((dg (cond ((deduction-graph?  dg-or-number) dg-or-number)
			 ((and (number? dg-or-number) (dgrv-index->dg dg-or-number)))
			 (else (imps-error "DEDUCTION-GRAPH-APPLY-COMMAND-INTERFACE: ~A is neither a deduction graph nor the index of one." dg-or-number))))
	       (command (coerce-to-command command-or-name))
	       (sqns
		(map (lambda (x) (dg-coerce-to-sequent-node dg x))
		     sqn-data)))
	  (bind (((command-or-script-current-node) (or (command-or-script-current-node) (cons (car sqns) '#f))))


	    (let ((last-index (deduction-graph-last-index dg)))
	      (iterate loop ((sqns sqns)
			     (last-index-before-command last-index))

		(if (null? sqns)
		    '#t
		    (let* ((sqn (car sqns))
			   (jump-from-previous
			    (ac-interface-compute-jump
			     sqn
			     (car (deduction-graph-history dg)))))
		      (apply (dg-command-argument-check command) sqn aux)
;;;		    (let ((unterminated-blocks
;;;			   (head-nodes-grounded-by-last-entry dg)))
;;;		      (and unterminated-blocks
;;;			   (or (not (eq? 'annotate (name command)))
;;;			       (not (memq? 'end-block aux)))
;;;			   (imps-warning "~A Unterminated blocks with grounded head nodes"
;;;					 (length unterminated-blocks))))
				       
		      (apply command sqn aux)
		      (build-and-post-dg-history-entry
		       dg
		       command
		       sqn
		       aux
		       last-index-before-command
		       jump-from-previous
		       comments)
		      (loop (cdr sqns) (deduction-graph-last-index dg)))))
	      (or (and (sequent-node? (car sqns))
		       (sequent-node-first-new-descendent last-index (car sqns)))
		  '#t)))))))
