;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald (inference syllogistic-inference))


(define (self-contrapose context assertion)
  (let ((assumptions (context-assumptions context)))
    (let ((victim
	   (or (any
		(lambda (a)
		  (and (or (negated-equation? a)
			   (negated-convergence? a))
		       a))
		assumptions)
	       (any
		(lambda (a)
		  (and (or (negated-equation? a)
			   (negated-convergence? a))
		       a))
		(ultimate-conjuncts assumptions))
	       (any (lambda (a)
		      (and (negation? a)
			   a))
		    assumptions)
	       (any identity assumptions))))
      (if (expression? victim)
	  (return
	   (context-add-assumption
	    (context-omit-assumption
	     context
	     victim)
	    (push-not assertion))
	   (push-not victim))
	  (return context assertion)))))

(define (context-simplify-assumptions context)
  (if (context-assumptions-already-simplified? context)
      (return)
      (iterate iter
	  ((asses (context-assumptions context))
	   (current-context context))
	(cond ((null? asses)
	       (set (context-assumptions-already-simplified? context) '#t)
	       (return))
	      ((memq? (car asses)
		      (context-assumptions current-context))
	       (iter asses
		     (context-predecessor current-context)))
	      (else
	       (add-context-entry
		context
		(context-insistently-simplify current-context
					      (car asses)
					      (context-simplification-persistence)))
	       (iter (cdr asses) current-context))))))

(define (syllogistic-inference-get-reduced-conjuncts expr exoscopes)
  (make-set 
   (reduce-conjunctions-and-universals
    (list (make-bound-variables-unique expr exoscopes))
    exoscopes)))

(define SYLLOGISTIC-FORWARDCHAIN-PERSISTENCE
  (make-simple-switch 'SYLLOGISTIC-FORWARDCHAIN-PERSISTENCE integer? 2))

(define (SYLLOGISTIC-FORWARDCHAIN context entry)
  (if (or (not (context-contains-entry? context entry))
	  (not-positive? (syllogistic-forwardchain-persistence)))
      (return)
      (bind (((syllogistic-forwardchain-persistence)
	      (-1+ (syllogistic-forwardchain-persistence)))
	     ((simplify-non-virgins?) '#f))
	(cond ((or (convergence? entry)
		   (convergence-in-sort? entry))
	       (context-simplify
		context
		(convergence-term entry)
		(syllogistic-forwardchain-persistence)))
	      ((disjunctive-formula? entry)
	       (syllogistic-forwardchain-simplify-disjuncts context entry))
	      ((let ((red
		      (context-recursively-seek-formal-symbols context entry)))
		 (and (not (eq? entry red))
		      red))
	       =>
	       (lambda (red)
		 (add-context-entry context red)
		 (context-simplify context red (syllogistic-forwardchain-persistence)))) 
	      (else
	       (let ((reduced-conjuncts
		      (syllogistic-inference-get-reduced-conjuncts
		       entry
		       (context-free-variables context))))
		 (walk
		  (lambda (e)
		    (if (disjunctive-formula? e)
			(syllogistic-forwardchain-simplify-disjuncts context e)))
		  reduced-conjuncts)))))))

(define (SYLLOGISTIC-FORWARDCHAIN-SIMPLIFY-DISJUNCTS context entry)
  (let ((conjunctive-component-lists
	 (map
	  (lambda (d-c)
	    (conjunctive-components d-c))
	  (disjunctive-components entry))))
    (if (not (null? conjunctive-component-lists))
	(add-context-entries
	 context
	 (big-cap conjunctive-component-lists)))
    (let ((reduced-disjuncts
	   (simplify-components-in-context
	    disjunction
	    (disjunctive-components entry)
	    context
	    (syllogistic-forwardchain-persistence)
	    context-simplify)))
      (add-context-entry
       context
       (disjunction-simplifier reduced-disjuncts)))))

(define (SYLLOGISTIC-FORWARDCHAIN-THROUGH-CONTEXT context)
  (if (or (context-assumptions-already-simplified? context)
	  (not-positive? (syllogistic-forwardchain-persistence)))
      (return)
      (block (walk
	      (lambda (a)
		(syllogistic-forwardchain context a))
	      (context-assumptions context))
	     (set (context-assumptions-already-simplified? context) '#t))))

(define (enrich-context context seeds)
  (if (not (list? seeds))				;temporary!!
      (syllogistic-enrichment context)
      (syllogistic-enrichment context)))

(define (syllogistic-enrichment context)
  (syllogistic-forwardchain-through-context context))

(define (CONTEXT-ADD-ASSUMPTIONS-AND-ENRICH context new-assumptions)
  (let ((context (context-add-assumptions context new-assumptions)))
    (enrich-context context new-assumptions)
    (walk (lambda (a) (syllogistic-forwardchain context a))
	  new-assumptions)
    context))

(define (CONTEXT-ADD-ASSUMPTION-AND-ENRICH context new-assumption)
  (context-add-assumptions-and-enrich context (list new-assumption)))

(define (CONTEXT-ENTAILS-CONTEXT? context-1 context-2)
  (or (eq? context-1 context-2)
      (every?
       (lambda (f)
	 (context-entails? context-1 f))
       (set-difference
	(context-assumptions context-2)
	(context-assumptions context-1)))))

(define (ENRICHED-CONTEXT-ENTAILS? context formula)
  (enrich-context context '#t)
  (context-entails? context formula))

(define (ENRICHED-CONTEXT-SIMPLIFY context expr)
  (enrich-context context '#t)
  (context-insistently-simplify context expr (context-simplification-persistence)))

(define (CONTEXT-SYLLOGISTICALLY-ENTAILS? context formula)
  (truth?
   (syllogistic-inference-simplify context formula)))

(define (SYLLOGISTIC-INFERENCE-SIMPLIFY context formula)
  (if (formula? formula)
      (let ((easy? (or (memq? formula (context-assumptions context))
		       (context-immediately-entails? context formula))))
	(if easy?
	    truth
	    (let ((simp (enriched-context-simplify context formula)))
	      (if (sequent-entailed? (build-sequent context simp) '#t)
		  truth
		  simp))))
      (syllogistic-inference-simplify-non-formula context formula)))

(define (syllogistic-inference-simplify-non-formula context formula)
  (enriched-context-simplify context formula))

(lset *sequent-entailment-cycling-tracer* (make-table))

(define (SEQUENT-ENTAILED? seq . strongly?)
  (if (table-entry *sequent-entailment-cycling-tracer* seq)
      '#f
      (bind (((table-entry *sequent-entailment-cycling-tracer* seq) '#t))
	(let ((entailed? (sequent-entailed-1? seq strongly?)))
	  (if entailed?
	      (add-context-entry (sequent-context seq) (sequent-assertion seq)))
	  entailed?))))

(define (sequent-entailed-1? seq strongly?)
  (ignore strongly?)
  (if (sequent-entailment-flag seq)
      '#t
      (let ((context (sequent-context seq))
	    (assertion (sequent-assertion seq)))
	(let ((simp (context-insistently-simplify
		     context
		     assertion
		     (context-simplification-persistence))))
	  (cond ((or (truth? simp)
		     (immediate-backchaining-opportunity context simp))
		 (make-sequent-entailed seq)
		 '#t)
		((receive (contra-context new-assertion)
		   (self-contrapose context simp)
		   (context-trivially-entails? contra-context new-assertion))
		 (make-sequent-entailed seq)
		 '#t) 
		;; Formerly:
		;;
		;; It's actually worthwhile to go ahead and see if the
		;; context might be absurd.
		;; 
		;; ((falsehood? simp)
		;;   '#f)
		;;		  
		;;		  ((let ((context (context-add-assumption-and-enrich
		;;				   context
		;;				   (context-simplify-virgin 
		;;				    context
		;;				    (push-not simp)
		;;				    (context-simplification-persistence)))))
		;;		     (context-entails? context falsehood))
		;;		   (make-sequent-entailed seq)
		;;		   '#t)
		(else '#f))))))

(define (SEQUENT-ENTAILS-SEQUENT? premise conclusion)
  (or (eq? premise conclusion)
      (and (eq? (sequent-assertion premise)
		(sequent-assertion conclusion))
	   (every?
	    (lambda (a)
	      (context-contains-entry? (sequent-context conclusion) a))
	    (sequent-assumptions premise)))
      (sequent-entailed? conclusion)
      (let ((concl-context (sequent-context conclusion))
	    (prem-context (sequent-context premise)))
	(and (context-entails-context? concl-context prem-context)
	     (sequent-entailed?
	      (build-sequent
	       (context-add-assumption
		concl-context
		(apply forall
		       (sequent-assertion premise)
		       (set-difference
			(free-variables (sequent-assertion premise))
			(free-variables prem-context))))
	       (sequent-assertion conclusion)))))))
					 
(define (FORMULA-ENTAILS-SEQUENT? formula sequent)
  (let ((formula					;ensure no conflicts of
	 (expression-change-free-variables		;free variables
	  formula
	  (set-intersection (free-variables formula)
			    (free-variables sequent)))))
    (let ((combined-sequent
	   (sequent-add-assumption sequent formula)))
      (sequent-entailed? combined-sequent))))

(define (SEQUENT-ADD-ASSUMPTION-AND-ENRICH sequent assumption)
  (build-sequent
   (context-add-assumption-and-enrich (sequent-context sequent) assumption)
   (sequent-assertion sequent)))


(define (run-proc-with-minor-premises proc)
  (bind ((undischarged-minor-premises nil)
	 ((accumulate-undischarged-minor-premises?) '#t))
    (let ((val (proc)))
      (return val (make-set undischarged-minor-premises)))))

;; SIMPLIFY-WITH-MINOR-PREMISES does the same simplification as does
;; syllogistic-inference-simplify, but as undischarged convergence requirements
;; are encountered, they are assembled into a list of minor premises.  The
;; procedure returns two values, namely the simplified assertion and the list
;; of undischarged minor premises.

(define (simplify-with-minor-premises context assertion)
  (receive (simp minors)
    (run-proc-with-minor-premises
     (lambda ()
       (enriched-context-simplify context assertion)))
    (let ((persist (context-simplification-persistence)))
      (iterate iter ((cooked-premises nil)
		     (minors minors))
	(if (null? minors)
	    (if (and (formula? simp)
		     (sequent-entailed? (build-sequent context simp)))
		(return truth cooked-premises)
		(return simp cooked-premises))
	    (let* ((seq (car minors))
		   (assertion (context-simplify (sequent-context seq)
						(sequent-assertion seq)
						persist)))
	      (if (truth? assertion)
		  (iter cooked-premises (cdr minors))
		  (iter
		   (add-set-element (build-sequent
				     (sequent-context seq)
				     assertion)
				    cooked-premises)
		   (cdr minors)))))))))



(define (ENRICH-BY-MATCHING-INSTANCES context constr lead hot-terms)
  (let ((exoscopes (free-variables context))
	(new-entries nil))
    (let ((enricher
	   (lambda (expr)
	     (let ((substs
		    (enrich-by-matching-get-substitutions context expr hot-terms exoscopes)))
	       (walk
		(lambda (subst)
		  (push new-entries (apply-substitution subst expr)))
		substs)))))	   
      (context-walk-entries-constructor-and-first-lead enricher context constr lead)
      (add-context-entries context new-entries))))

(define (ENRICH-BY-MATCHING-GET-SUBSTITUTIONS context expr hot-terms exoscopes)
  (let ((substs nil))
    (iterate iter ((hot-terms hot-terms))
      (if
       (null? hot-terms)
       substs
       (let ((new-substs
	      (match-pattern-within-host-under-exoscopes
	       (car hot-terms) expr exoscopes '#f)))
	 (walk
	  (lambda (subst)
	    (if (and (succeed? subst)
		     (context-entails-substitution-defined? context subst)
		     (not (any?
			   (lambda (subst2)
			     (substitutions-equal? subst subst2))
			   substs)))
		(push substs subst)))
	  new-substs)
	 (iter (cdr hot-terms)))))))

;;; (context-generate-instance context generality substitution)
;;; checks that generality is context-entailed in context and that substitution
;;; is defined in it.  If so, the result of applying the substitution to the
;;; universal matrix (under the exoscopes of the context) is added as a new
;;; context entry.  

(define (context-generate-instance context generality substitution)
  (if (or (not (context-entails? context generality))
	  (not (context-strongly-entails-substitution-defined?
		context
		substitution
		(context-simplification-persistence))))
      '#f
      (let ((instance (apply-subst-to-exp-with-exoscopes
		       substitution
		       (universal-matrix generality (context-free-variables context))
		       (context-free-variables context))))
	(add-context-entry context instance)
	'#t)))
	
