#include "defines.h"
#include "main.h"
#include "files.h"
#include "place.h"

static float scale[2][3];
static float curr_box[4];
static void mult_y( float f);
static void mult_x( float f);
static void translate( float dx, float dy);
static void rotate( int i);

export void set_scale()
{
	/* graph is originally placed with */
	/* 0 <= x <= max_x, right positive, unit distance 'DIST' */
	/* 0 <= y <= max_y, down positive, unit distance 1. */
	/* now setup a transformation matrix to scale this to */
	/* the requested bounding box bbox[4] = {xll, yll, xur, yur} */

	scale[0][0] = 1.0;
	scale[1][1] = 1.0;
	curr_box[2] = max_x;
	curr_box[3] = max_y;

	/* Turn original y-placement to unit distances in up+ coords */
	mult_y( -DIST);

	/* perform requested rotation */
	if (rotation) rotate( rotation);

	if (!boxarg && !postscript)
	{	/* no bbox known, keep default scaling, move to 0,0 as ll */
		translate( -curr_box[0], -curr_box[1]);
	} else
	{	/* choose scaling factor, is always positive ! */
		float mx, my, mm;

		/* prevent division by 0 */
		if (0.0 == curr_box[2] - curr_box[0])
		{	curr_box[0] -= 0.5*DIST;
			curr_box[2] += 0.5*DIST;
		}
		if (0.0 == curr_box[3] - curr_box[1])
		{	curr_box[1] -= 0.5*DIST;
			curr_box[3] += 0.5*DIST;
		}

		mx = (bbox[2] - bbox[0])/(curr_box[2] - curr_box[0]);
		my = (bbox[3] - bbox[1])/(curr_box[3] - curr_box[1]);

		mm = margin/100.0;

		mx *= 1.0 - 2*mm;
		my *= 1.0 - 2*mm;

		if (!flexscale)
		{	if (mx > my) mx = my;
			else	my = mx;
		}
	
		/* now transform to bbox */
		/* sizing */
		mult_x( mx);
		mult_y( my);

		/* move to lower-left = 0,0 */
		translate( bbox[0] - curr_box[0], bbox[1] - curr_box[1]);

		/* move to requested margin */
		translate( mm*(bbox[2]-bbox[0]), mm*(bbox[3]-bbox[1]));
	}

	if (debuglevel >= 3)
	{	verbose( "Transformation matrix is:  %g %g %g\n",
			scale[0][0], scale[0][1], scale[0][2]);
		verbose( "                           %g %g %g\n",
			scale[1][0], scale[1][1], scale[1][2]);
		verbose( "Graph bbox after scaling is %g %g %g %g\n",
			curr_box[0], curr_box[1], curr_box[2], curr_box[3]);
	}
}

export void do_scale( int xin, int yin, float *x, float *y)
{
	*x = scale[0][0] * xin + scale[0][1] * yin + scale[0][2];
	*y = scale[1][0] * xin + scale[1][1] * yin + scale[1][2];
}

#define Exch( x1, x2)	{float h=x1; x1=x2; x2=h;}

static void mult_y( float f)
{
	int i;

	for (i=0; i<3; i++)
		scale[1][i] *= f;

	curr_box[1] *= f;
	curr_box[3] *= f;
	if (f < 0.0) Exch( curr_box[1], curr_box[3]);
}

static void mult_x( float f)
{
	int i;
	for (i=0; i<3; i++)
		scale[0][i] *= f;

	curr_box[0] *= f;
	curr_box[2] *= f;
	if (f < 0.0) Exch( curr_box[0], curr_box[2]);
}

static void translate( float dx, float dy)
{
	scale[0][2] += dx;
	scale[1][2] += dy;

	curr_box[0] += dx;
	curr_box[2] += dx;
	curr_box[1] += dy;
	curr_box[3] += dy;
}

static void rotate( int n)
{	/* rotate clockwise over n*90 degrees */
	int j;
	float h;

	/* transform n to be within 0 <= n <= 3 */
	if (n<0)
	{	mult_y( -1);
		n = -n;
	}
	n = n & 3;

	while (n--)
	{	/* rotate over 90 degrees */
		for (j=0; j<3; j++)
		{	Exch( scale[0][j], scale[1][j]);
			scale[0][j] *= -1;
		}
		
		h = curr_box[0];
		curr_box[0] = - curr_box[3];
		curr_box[3] = curr_box[2];
		curr_box[2] = - curr_box[1];
		curr_box[1] = h;
	}
}
