/******************* Useful programming aids *********************/
typedef int Boolean;
#define True 1
#define False 0

#define DIST 6		/* node distances in horizontal placement */

#ifndef NULL
#define NULL ((void *)(0))
#endif

#define myfree(p)	{MyFree(p); (p)=(void *)0;}
#define newstruct(type)	((type *)(mycalloc(1, sizeof(type))))
#define newarray(n,type)	((type *)(mycalloc(n, sizeof(type))))

#define link_node(listp,node)	{(node)->next = *(listp);\
				 if (*(listp))\
					(*(listp))->prevp = &((node)->next);\
				 *(listp) = node;\
				 (node)->prevp = listp;\
				}
#define unlink_node(node)	{if ((node)->next)\
					(node)->next->prevp = (node)->prevp;\
				 if ((node)->prevp)\
					 *((node)->prevp) = (node)->next;\
				 (node)->next = NULL;\
				 (node)->prevp = NULL;\
				}
#define link_edge(edge,fromnode,tonode)	{edge->from = fromnode;\
				 edge->to = tonode;\
				 edge->next_outedge = (fromnode)->outedges;\
				 (fromnode)->outedges = edge;\
				 edge->next_inedge = (tonode)->inedges;\
				 (tonode)->inedges = edge;\
				}
#define unlink_edge(edge)	{struct edge **Ep;\
				 for (Ep=&((edge)->from->outedges); *Ep;\
						Ep=&((*Ep)->next_outedge))\
					if (*Ep == edge) break;\
				 if (*Ep) *Ep = (edge)->next_outedge;\
				 for (Ep=&((edge)->to->inedges); *Ep;\
						Ep=&((*Ep)->next_inedge))\
					if (*Ep == edge) break;\
				 if (*Ep) *Ep = (edge)->next_inedge;\
				 (edge)->to = NULL;\
				 (edge)->from = NULL;\
				}

#define export

/****************** Program constant values ***********************/
#define Bufsize 4096	/* line length */

/****************** typedefs **************************************/
typedef struct hash_table *Hash_table_p;

typedef struct line
{	char *text;
	struct node *node;
	struct edge *edge;
	struct line *next;
} Line;

typedef struct node
{	int x, y;
	int flag;
	int incount;
	char *name;
	struct node *next;
	struct node **prevp; /* doublelinked list by pointing to last 'next'*/
	struct node *super;  /* to represent a nodeset with same y */
	struct edge *inedges;
	struct edge *outedges;
} Node;

typedef struct edge
{	struct node *from;
	struct node *to;
	struct edge *next_inedge;
	struct edge *next_outedge;
	Boolean reversed;
} Edge;
