/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/

#ifndef true
#define true 1
#define false 0
#endif

#ifndef nil
#define nil 0L
#endif


#define ZERO 0.0
#define ONE 1.0
#define TWO 2.0
#define THREE 3.0
#define FOUR 4.0
#define EIGHT 8.0
#define HALF 0.5
#define QUARTER 0.25
#define RMIN -1.0E20
#define RMAX 1.0E20
#define SMALL 1.0E-20
#define REALPI  (3.14159265358979323846)
#define REALPI2  (1.57079632679489661923)



typedef float REAL;
typedef void*PTR;
typedef int(*PROC)();
typedef REAL(*REALPROC)();
typedef PTR(*PTRPROC)();
typedef void(*VOIDPROC)();



extern void*ZIBAlloc();
extern void ZIBFree();
extern REAL ZIBSeconds();
extern int ZIBReadFile();


extern char*kaskPath,*globBuf;
extern long allocMem;
extern int goon;



#define LMAX 100


#define LISTLIST 0
#define PTVEC  1
#define EDGVEC  2
#define TRVEC  3
#define LOCALSTIFF 4
#define SPARSE6  5
#define SPARSE12 6
#define SPARSE18 7
#define LISTELEM 8
#define PTELEM  9
#define EDGELEM  10
#define TRELEM  11
#define MAXLISTS 12
#define NOLIST  -1



struct PTRELEM
{
PTR pt;
struct PTRELEM*next;
};
typedef struct PTRELEM PTRELEM;
typedef PTRELEM*PTRLIST;



extern int InitFixedLists();
extern int InitList();
extern void ReturnList();
extern PTR *GetElem();
extern void ReturnElem();



static PTR**freeLists,**listBuckets;
static int*listLngs,*bucketLngs;
static int maxL= -1;


static PTR*GetBucket();





int InitFixedLists(maxLists)
int maxLists;
{
int k;
freeLists= (PTR**)ZIBAlloc((long)maxLists*sizeof(PTR*));

listBuckets= (PTR**)ZIBAlloc((long)maxLists*sizeof(PTR*));
listLngs= (int*)ZIBAlloc((long)maxLists*sizeof(int));
bucketLngs= (int*)ZIBAlloc((long)maxLists*sizeof(int));
if(bucketLngs==nil)return false;

maxL= maxLists;
for(k= 0;k<maxL;k++)
{
freeLists[k]= nil;
listBuckets[k]= nil;
listLngs[k]= 0;
bucketLngs[k]= 0;
}


return InitList(LISTLIST,2*sizeof(PTR),200);
}



int InitList(no,lng,bucketSize)
int no,lng,bucketSize;
{
if((no<0)||(no>maxL))
{
sprintf(globBuf,"Lists: bad list index %d\n",no);ZIBStdOut(globBuf);
return false;
}

if(listLngs[no]!=0)
{
sprintf(globBuf,"Lists: length redefinition not allowed (list %d)\n",no);ZIBStdOut(globBuf);
return false;
}



listLngs[no]= lng;
bucketLngs[no]= bucketSize;
return true;
}



void ReturnList(no)
int no;
{
PTR*buckets,*saveBucket;

if((no<0)||(no>maxL))
{sprintf(globBuf,"Lists: bad list index %d\n",no);ZIBStdOut(globBuf);return;}

buckets= listBuckets[no];
while(buckets!=nil)
{
ZIBFree((PTR)buckets[0]);
saveBucket= buckets;
buckets= (PTR*)buckets[0];
ReturnElem(LISTLIST,(PTR)saveBucket);
}
freeLists[no]= nil;
listLngs[no]= 0;
bucketLngs[no]= 0;


return;
}



PTR* GetElem(no)
int no;
{
PTR*elem,**lst;
if((no<0)||(no>maxL))
{sprintf(globBuf,"Lists: bad list index %d\n",no);ZIBStdOut(globBuf);return false;}

if(freeLists[no]==nil)

{
freeLists[no]= GetBucket(listLngs[no],bucketLngs[no]);
if(freeLists[no]==nil)return false;
if(no!=LISTLIST)
{
lst= (PTR**)GetElem(LISTLIST);
if(lst==nil)return false;
lst[0]= freeLists[no];
lst[1]= listBuckets[no];
listBuckets[no]= (PTR*)lst;
}
}


elem= freeLists[no];
freeLists[no]= (PTR*)freeLists[no][0];
return(PTR*)memset(elem,0,listLngs[no]);
}


void ReturnElem(no,elem)
int no;
PTR* elem;
{
if((no<0)||(no>maxL))
{sprintf(globBuf,"Lists: bad list index %d\n",no);ZIBStdOut(globBuf);return;}

elem[0]= (PTR)freeLists[no];
freeLists[no]= elem;

return;
}



static PTR*GetBucket(lng,bucketSize)
int lng,bucketSize;
{
PTR*bucket,*pt;
char *ptchar;
int k;
bucket= (PTR*)ZIBAlloc((long)bucketSize*lng);
if(bucket==nil)return nil;

pt= bucket;
ptchar= (char*)pt+lng;
for(k= 0;k<bucketSize-1;k++)
{
pt[0]= (PTR)ptchar;
pt= (PTR*)ptchar;
ptchar+= lng;
}
pt[0]= nil;


return bucket;
}

