/*
 * Decompiled with CFR 0.152.
 */
package jbet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jbet.BranchTarget;
import jbet.ClassFileException;
import jbet.ConstantPool;
import jbet.Instruction;
import jbet.LineWriter;

public class ExceptionRec
implements Cloneable {
    public BranchTarget start = new BranchTarget();
    public BranchTarget end = new BranchTarget();
    public BranchTarget handler = new BranchTarget();
    public String catchType;
    int catchIndex;
    int marker;

    ExceptionRec dup() {
        ExceptionRec exceptionRec = this;
        try {
            ExceptionRec exceptionRec2 = (ExceptionRec)exceptionRec.clone();
            return exceptionRec2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ExceptionRec(Instruction start, Instruction end, Instruction handler, String ct) {
        this.start.instr = start;
        this.end.instr = end;
        this.handler.instr = handler;
        this.catchType = ct;
    }

    ExceptionRec(DataInputStream dataIn, ConstantPool constantPool) throws IOException, ClassFileException {
        this.start.offset = dataIn.readUnsignedShort();
        this.end.offset = dataIn.readUnsignedShort();
        this.handler.offset = dataIn.readUnsignedShort();
        this.catchIndex = dataIn.readUnsignedShort();
        this.catchType = this.catchIndex == 0 ? null : constantPool.cpClassAt(this.catchIndex).string();
    }

    void resolveConstants(ConstantPool constantPool) {
        ExceptionRec exceptionRec;
        ExceptionRec exceptionRec2 = exceptionRec = this;
        ExceptionRec exceptionRec3 = exceptionRec;
        ConstantPool constantPool2 = constantPool;
        if (exceptionRec2.catchType != null) {
            int n;
            ExceptionRec exceptionRec4 = exceptionRec;
            String string = exceptionRec4.catchType;
            exceptionRec4.catchIndex = n = constantPool2.internClass(string);
        } else {
            exceptionRec3.catchIndex = 0;
        }
    }

    void writeFile(DataOutputStream dataOutputStream) throws IOException {
        ExceptionRec exceptionRec = this;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        ExceptionRec exceptionRec2 = exceptionRec;
        BranchTarget branchTarget = exceptionRec2.start;
        int n = branchTarget.offset;
        DataOutputStream dataOutputStream3 = dataOutputStream2;
        dataOutputStream3.writeShort(n);
        BranchTarget branchTarget2 = exceptionRec2.end;
        int n2 = branchTarget2.offset;
        dataOutputStream3.writeShort(n2);
        BranchTarget branchTarget3 = exceptionRec2.handler;
        int n3 = branchTarget3.offset;
        dataOutputStream3.writeShort(n3);
        int n4 = exceptionRec2.catchIndex;
        dataOutputStream3.writeShort(n4);
    }

    void print(LineWriter lineWriter) {
        String string;
        LineWriter lineWriter2;
        ExceptionRec exceptionRec;
        ExceptionRec exceptionRec2 = exceptionRec = this;
        ExceptionRec exceptionRec3 = exceptionRec;
        LineWriter lineWriter3 = lineWriter2 = lineWriter;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = stringBuffer.append("\tException: PCrange(");
        ExceptionRec exceptionRec4 = exceptionRec;
        BranchTarget branchTarget = exceptionRec4.start;
        Instruction instruction = branchTarget.instr;
        int n = instruction.pc();
        StringBuffer stringBuffer3 = stringBuffer2.append(n);
        StringBuffer stringBuffer4 = stringBuffer3.append("-");
        BranchTarget branchTarget2 = exceptionRec4.end;
        if (branchTarget2.instr == null) {
            string = "";
        } else {
            StringBuffer stringBuffer5 = new StringBuffer();
            StringBuffer stringBuffer6 = stringBuffer5.append("");
            BranchTarget branchTarget3 = exceptionRec3.end;
            Instruction instruction2 = branchTarget3.instr;
            int n2 = instruction2.pc();
            StringBuffer stringBuffer7 = stringBuffer6.append(n2);
            string = stringBuffer7.toString();
        }
        StringBuffer stringBuffer8 = stringBuffer4.append(string);
        StringBuffer stringBuffer9 = stringBuffer8.append(") handlerPC(");
        ExceptionRec exceptionRec5 = exceptionRec2;
        BranchTarget branchTarget4 = exceptionRec5.handler;
        Instruction instruction3 = branchTarget4.instr;
        int n3 = instruction3.pc();
        StringBuffer stringBuffer10 = stringBuffer9.append(n3);
        StringBuffer stringBuffer11 = stringBuffer10.append(") catchType(");
        String string2 = exceptionRec5.catchType;
        StringBuffer stringBuffer12 = stringBuffer11.append(string2);
        StringBuffer stringBuffer13 = stringBuffer12.append(")");
        String string3 = stringBuffer13.toString();
        lineWriter2.println(string3);
    }

    ExceptionRec() {
    }
}

