# generated by datamodel-codegen:
#   filename:  allof_root_model_constraints.json
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from typing import Any, Dict, List, Optional

from pydantic import BaseModel, EmailStr, Field, conint, constr


class StringDatatype(BaseModel):
    __root__: constr(regex=r'^\S(.*\S)?$') = Field(
        ..., description='A base string type.'
    )


class ConstrainedStringDatatype(BaseModel):
    __root__: constr(regex=r'(?=^\S(.*\S)?$)(?=^[A-Z].*)', min_length=1) = Field(
        ..., description='A constrained string.'
    )


class IntegerDatatype(BaseModel):
    __root__: int = Field(..., description='A whole number.')


class NonNegativeIntegerDatatype(BaseModel):
    __root__: conint(ge=0) = Field(..., description='Non-negative integer.')


class BoundedIntegerDatatype(BaseModel):
    __root__: conint(ge=0, le=100) = Field(
        ..., description='Integer between 0 and 100.'
    )


class EmailDatatype(BaseModel):
    __root__: EmailStr = Field(..., description='Email with format.')


class FormattedStringDatatype(BaseModel):
    __root__: EmailStr = Field(..., description='A string with email format.')


class ObjectBase(BaseModel):
    id: Optional[int] = None


class ObjectWithAllOf(ObjectBase):
    name: Optional[str] = None


class MultiRefAllOf(BaseModel):
    pass


class NoConstraintAllOf(BaseModel):
    pass


class IncompatibleTypeAllOf(BaseModel):
    pass


class ConstraintWithProperties(BaseModel):
    extra: Optional[str] = None


class ConstraintWithItems(BaseModel):
    pass


class NumberIntegerCompatible(BaseModel):
    __root__: conint(ge=0) = Field(
        ..., description='Number and integer are compatible.'
    )


class RefWithSchemaKeywords(BaseModel):
    __root__: constr(regex=r'^\S(.*\S)?$', min_length=5, max_length=100) = Field(
        ..., description='Ref with additional schema keywords.'
    )


class ArrayDatatype(BaseModel):
    __root__: List[str]


class RefToArrayAllOf(BaseModel):
    pass


class ObjectNoPropsDatatype(BaseModel):
    pass


class RefToObjectNoPropsAllOf(ObjectNoPropsDatatype):
    pass


class PatternPropsDatatype(BaseModel):
    __root__: Dict[constr(regex=r'^S_'), str]


class RefToPatternPropsAllOf(BaseModel):
    pass


class NestedAllOfDatatype(BaseModel):
    pass


class RefToNestedAllOfAllOf(NestedAllOfDatatype):
    pass


class ConstraintsOnlyDatatype(BaseModel):
    __root__: Any = Field(..., description='Constraints only, no type.')


class RefToConstraintsOnlyAllOf(BaseModel):
    __root__: Any = Field(..., description='Ref to constraints-only schema.')


class NoDescriptionAllOf(BaseModel):
    __root__: constr(regex=r'^\S(.*\S)?$', min_length=5) = Field(
        ..., description='A base string type.'
    )


class EmptyConstraintItemAllOf(BaseModel):
    __root__: constr(regex=r'^\S(.*\S)?$', max_length=50) = Field(
        ..., description='AllOf with empty constraint item.'
    )


class ConflictingFormatAllOf(BaseModel):
    pass


class Model(BaseModel):
    name: Optional[ConstrainedStringDatatype] = None
    count: Optional[NonNegativeIntegerDatatype] = None
    percentage: Optional[BoundedIntegerDatatype] = None
    email: Optional[EmailDatatype] = None
    obj: Optional[ObjectWithAllOf] = None
    multi: Optional[MultiRefAllOf] = None
    noconstraint: Optional[NoConstraintAllOf] = None
    incompatible: Optional[IncompatibleTypeAllOf] = None
    withprops: Optional[ConstraintWithProperties] = None
    withitems: Optional[ConstraintWithItems] = None
    numint: Optional[NumberIntegerCompatible] = None
    refwithkw: Optional[RefWithSchemaKeywords] = None
    refarr: Optional[RefToArrayAllOf] = None
    refobjnoprops: Optional[RefToObjectNoPropsAllOf] = None
    refpatternprops: Optional[RefToPatternPropsAllOf] = None
    refnestedallof: Optional[RefToNestedAllOfAllOf] = None
    refconstraintsonly: Optional[RefToConstraintsOnlyAllOf] = None
    nodescription: Optional[NoDescriptionAllOf] = None
    emptyconstraint: Optional[EmptyConstraintItemAllOf] = None
    conflictingformat: Optional[ConflictingFormatAllOf] = None
