# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, Type, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._workspace_settings_operations import (
    build_create_request,
    build_delete_request,
    build_get_request,
    build_list_request,
    build_update_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class WorkspaceSettingsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.v2017_08_01_preview.aio.SecurityCenter`'s
        :attr:`workspace_settings` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.WorkspaceSetting"]:
        """Settings about where we should store your security data and logs. If the result is empty, it
        means that no custom-workspace configuration was set.

        :return: An iterator like instance of either WorkspaceSetting or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2017-08-01-preview")
        )
        cls: ClsType[_models.WorkspaceSettingList] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("WorkspaceSettingList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, workspace_setting_name: str, **kwargs: Any) -> _models.WorkspaceSetting:
        """Settings about where we should store your security data and logs. If the result is empty, it
        means that no custom-workspace configuration was set.

        :param workspace_setting_name: Name of the security setting. Required.
        :type workspace_setting_name: str
        :return: WorkspaceSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2017-08-01-preview")
        )
        cls: ClsType[_models.WorkspaceSetting] = kwargs.pop("cls", None)

        _request = build_get_request(
            workspace_setting_name=workspace_setting_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("WorkspaceSetting", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create(
        self,
        workspace_setting_name: str,
        workspace_setting: _models.WorkspaceSetting,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.WorkspaceSetting:
        """creating settings about where we should store your security data and logs.

        :param workspace_setting_name: Name of the security setting. Required.
        :type workspace_setting_name: str
        :param workspace_setting: Security data setting object. Required.
        :type workspace_setting: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: WorkspaceSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        workspace_setting_name: str,
        workspace_setting: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.WorkspaceSetting:
        """creating settings about where we should store your security data and logs.

        :param workspace_setting_name: Name of the security setting. Required.
        :type workspace_setting_name: str
        :param workspace_setting: Security data setting object. Required.
        :type workspace_setting: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: WorkspaceSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self, workspace_setting_name: str, workspace_setting: Union[_models.WorkspaceSetting, IO[bytes]], **kwargs: Any
    ) -> _models.WorkspaceSetting:
        """creating settings about where we should store your security data and logs.

        :param workspace_setting_name: Name of the security setting. Required.
        :type workspace_setting_name: str
        :param workspace_setting: Security data setting object. Is either a WorkspaceSetting type or a
         IO[bytes] type. Required.
        :type workspace_setting: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting or
         IO[bytes]
        :return: WorkspaceSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2017-08-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.WorkspaceSetting] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(workspace_setting, (IOBase, bytes)):
            _content = workspace_setting
        else:
            _json = self._serialize.body(workspace_setting, "WorkspaceSetting")

        _request = build_create_request(
            workspace_setting_name=workspace_setting_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("WorkspaceSetting", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        workspace_setting_name: str,
        workspace_setting: _models.WorkspaceSetting,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.WorkspaceSetting:
        """Settings about where we should store your security data and logs.

        :param workspace_setting_name: Name of the security setting. Required.
        :type workspace_setting_name: str
        :param workspace_setting: Security data setting object. Required.
        :type workspace_setting: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: WorkspaceSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        workspace_setting_name: str,
        workspace_setting: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.WorkspaceSetting:
        """Settings about where we should store your security data and logs.

        :param workspace_setting_name: Name of the security setting. Required.
        :type workspace_setting_name: str
        :param workspace_setting: Security data setting object. Required.
        :type workspace_setting: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: WorkspaceSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self, workspace_setting_name: str, workspace_setting: Union[_models.WorkspaceSetting, IO[bytes]], **kwargs: Any
    ) -> _models.WorkspaceSetting:
        """Settings about where we should store your security data and logs.

        :param workspace_setting_name: Name of the security setting. Required.
        :type workspace_setting_name: str
        :param workspace_setting: Security data setting object. Is either a WorkspaceSetting type or a
         IO[bytes] type. Required.
        :type workspace_setting: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting or
         IO[bytes]
        :return: WorkspaceSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2017_08_01_preview.models.WorkspaceSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2017-08-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.WorkspaceSetting] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(workspace_setting, (IOBase, bytes)):
            _content = workspace_setting
        else:
            _json = self._serialize.body(workspace_setting, "WorkspaceSetting")

        _request = build_update_request(
            workspace_setting_name=workspace_setting_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("WorkspaceSetting", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, workspace_setting_name: str, **kwargs: Any
    ) -> None:
        """Deletes the custom workspace settings for this subscription. new VMs will report to the default
        workspace.

        :param workspace_setting_name: Name of the security setting. Required.
        :type workspace_setting_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2017-08-01-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            workspace_setting_name=workspace_setting_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
